/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.BaseCommandHandler;
import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import com.atlassian.bitbucket.scm.CommandOutputHandlerSupport;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LineOutputHandler
extends BaseCommandHandler
implements CommandOutputHandlerSupport {
    private static final LineReader.Mode DEFAULT_MODE = LineReader.Mode.MODE_DETECT;
    private final Charset encoding;
    private LineReader.Mode mode;

    protected LineOutputHandler() {
        this((Charset)null, null);
    }

    protected LineOutputHandler(@Nullable String encoding) {
        this(encoding == null ? null : Charset.forName(encoding), DEFAULT_MODE);
    }

    protected LineOutputHandler(@Nullable String encoding, @Nullable LineReader.Mode mode) {
        this(encoding == null ? null : Charset.forName(encoding), mode);
    }

    protected LineOutputHandler(@Nullable Charset encoding) {
        this(encoding, null);
    }

    protected LineOutputHandler(@Nullable Charset encoding, @Nullable LineReader.Mode mode) {
        this.encoding = encoding;
        this.mode = mode == null ? DEFAULT_MODE : mode;
    }

    @Nullable
    public Charset getEncoding() {
        return this.encoding;
    }

    public void process(@Nonnull InputStream output) throws IOException {
        LineReader reader = this.createReader(output, this.encoding);
        try {
            this.process(reader);
        }
        finally {
            Closeables.closeQuietly((InputStream)output);
        }
    }

    public void setMode(@Nonnull LineReader.Mode mode) {
        this.mode = Objects.requireNonNull(mode, "mode");
    }

    protected LineReader createReader(@Nonnull InputStream stream, @Nullable Charset encoding) {
        if (encoding == null) {
            encoding = Charset.defaultCharset();
        }
        return new ReaderLineReader(this.mode, new BufferedReader(new InputStreamReader(stream, encoding)));
    }

    protected void process(@Nonnull LineReader reader) throws IOException {
        int counter = 0;
        try {
            String line;
            while (!this.isCanceled() && (line = reader.readLine()) != null) {
                this.resetWatchdog();
                this.processLine(counter++, line);
            }
            this.processInputEnd(counter);
        }
        catch (InterruptedIOException e) {
            this.processEndByException(counter);
        }
        catch (IOException e) {
            this.processEndByException(counter);
            throw e;
        }
    }

    protected void processEndByException(int counter) {
    }

    protected void processInputEnd(int lineCount) throws IOException {
    }

    protected abstract void processLine(int var1, String var2);
}

