/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleFile
extends File {
    private final String contentId;
    private final Path path;
    private final Long size;

    private SimpleFile(Builder builder) {
        this.contentId = builder.contentId;
        this.path = builder.path;
        this.size = builder.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleFile) {
            SimpleFile f = (SimpleFile)((Object)o);
            return this.getPath().equals(f.getPath()) && com.google.common.base.Objects.equal((Object)this.getContentId(), (Object)f.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nonnull
    public OptionalLong getSize() {
        return this.size == null ? OptionalLong.empty() : OptionalLong.of(this.size);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "SimpleFile{path='" + this.path + "', contentId='" + this.contentId + "'}";
    }

    public static class Builder {
        private String contentId;
        private Path path;
        private Long size;

        public Builder() {
        }

        public Builder(@Nonnull File file) {
            this.contentId = Objects.requireNonNull(file, "file").getContentId();
            this.path = file.getPath();
            file.getSize().ifPresent(this::size);
        }

        @Nonnull
        public SimpleFile build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required.");
            return new SimpleFile(this);
        }

        @Nonnull
        public Builder contentId(@Nullable String value) {
            this.contentId = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull Path value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Objects.requireNonNull(value, "path")));
        }

        @Nonnull
        public Builder size(long value) {
            Preconditions.checkArgument((value > -1L ? 1 : 0) != 0, (Object)"File sizes may not be negative.");
            this.size = value;
            return this;
        }
    }
}

