/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.content.DiffSegment;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;

public class SimpleDiffSegment
implements DiffSegment {
    private final List<DiffLine> lines;
    private final boolean truncated;
    private final DiffSegmentType type;

    private SimpleDiffSegment(DiffSegmentType type, boolean truncated, List<DiffLine> lines) {
        this.type = type;
        this.lines = lines;
        this.truncated = truncated;
    }

    @Nonnull
    public List<DiffLine> getLines() {
        return this.lines;
    }

    @Nonnull
    public DiffSegmentType getType() {
        return this.type;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private ImmutableList.Builder<DiffLine> lines = ImmutableList.builder();
        private boolean truncated;
        private DiffSegmentType type;

        public Builder() {
        }

        public Builder(DiffSegment segment) {
            this();
            this.truncated = segment.isTruncated();
            this.type = segment.getType();
            this.lines.addAll((Iterable)segment.getLines());
        }

        public SimpleDiffSegment build() {
            return new SimpleDiffSegment(this.type, this.truncated, (List<DiffLine>)this.lines.build());
        }

        public Builder line(DiffLine value) {
            this.lines.add((Object)value);
            return this;
        }

        public Builder lines(DiffLine value, DiffLine ... values) {
            this.lines.add((Object)value).add((Object[])values);
            return this;
        }

        public Builder lines(Iterable<DiffLine> value) {
            this.lines.addAll(value);
            return this;
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }

        public Builder type(DiffSegmentType value) {
            this.type = value;
            return this;
        }
    }
}

