/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleCommitGraphNode
implements CommitGraphNode {
    private final MinimalCommit commit;
    private final Collection<MinimalCommit> parents;

    private SimpleCommitGraphNode(MinimalCommit commit, Collection<MinimalCommit> parents) {
        this.commit = commit;
        this.parents = parents;
    }

    @Nonnull
    public MinimalCommit getCommit() {
        return this.commit;
    }

    @Nonnull
    public Collection<MinimalCommit> getParents() {
        return this.parents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleCommitGraphNode)) {
            return false;
        }
        SimpleCommitGraphNode that = (SimpleCommitGraphNode)o;
        return this.commit.equals(that.getCommit()) && this.parents.equals(that.parents);
    }

    public int hashCode() {
        return 31 * this.commit.hashCode() + this.parents.hashCode();
    }

    public String toString() {
        return "SimpleCommitGraphNode{commit=" + this.commit + ", parents=" + this.parents + "}";
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<MinimalCommit> parents = ImmutableSet.builder();
        private MinimalCommit commit;

        public Builder() {
        }

        public Builder(@Nonnull Commit value) {
            this.commit = (MinimalCommit)Objects.requireNonNull(value, "commit");
            this.parents.addAll((Iterable)value.getParents());
        }

        public Builder(@Nonnull SimpleCommitGraphNode value) {
            this.commit(Objects.requireNonNull(value, "node").getCommit());
            this.parents(value.getParents());
        }

        public SimpleCommitGraphNode build() {
            Preconditions.checkState((this.commit != null ? 1 : 0) != 0, (Object)"A commit must be supplied");
            return new SimpleCommitGraphNode(this.commit, (Collection<MinimalCommit>)this.parents.build());
        }

        public Builder commit(@Nonnull MinimalCommit value) {
            this.commit = Objects.requireNonNull(value, "value");
            return this;
        }

        public Builder parents(@Nonnull Iterable<MinimalCommit> values) {
            Builder.addIf(Objects::nonNull, this.parents, values);
            return this;
        }

        public Builder parents(@Nonnull MinimalCommit value, MinimalCommit ... values) {
            Builder.addIf(Objects::nonNull, this.parents, (Object)value, (Object[])values);
            return this;
        }
    }
}

