/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit.graph;

import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class CommitGraphContext {
    private final Set<String> excludes;
    private final Set<String> includes;
    private final boolean includeAll;
    private boolean anyNodeVisited;

    private CommitGraphContext(Set<String> excludes, Set<String> includes) {
        this.excludes = Sets.newHashSet(excludes);
        this.includes = Sets.newHashSet(includes);
        this.includes.removeAll(this.excludes);
        this.includeAll = includes.isEmpty();
        this.anyNodeVisited = false;
    }

    public boolean visit(CommitGraphNode node) {
        if (this.excludes.remove(node.getCommit().getId())) {
            this.exclude(node.getParents());
        } else {
            if (this.includeAll) {
                this.anyNodeVisited = true;
                return true;
            }
            if (this.includes.remove(node.getCommit().getId())) {
                this.include(node.getParents());
                this.anyNodeVisited = true;
                return true;
            }
        }
        return false;
    }

    public void include(Collection<MinimalCommit> includes) {
        HashSet newIncludes = Sets.newHashSet((Iterable)Collections2.transform(includes, MinimalCommit::getId));
        newIncludes.removeAll(this.excludes);
        this.includes.addAll(newIncludes);
    }

    public void exclude(Collection<MinimalCommit> excludes) {
        HashSet newExcludes = Sets.newHashSet((Iterable)Collections2.transform(excludes, MinimalCommit::getId));
        this.excludes.addAll(newExcludes);
        this.includes.removeAll(newExcludes);
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public boolean isAnyNodeVisited() {
        return this.anyNodeVisited;
    }

    public boolean isTraversing() {
        return this.includeAll || !this.includes.isEmpty();
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();

        public Builder() {
        }

        public Builder(@Nonnull CommitGraphContext context) {
            Objects.requireNonNull(context, "context");
            this.exclude(context.excludes);
            this.include(context.includes);
        }

        public CommitGraphContext build() {
            ImmutableSet excludes = this.excludes.build();
            ImmutableSet includes = this.includes.build();
            return new CommitGraphContext((Set<String>)excludes, (Set<String>)includes);
        }

        public Builder exclude(Iterable<String> values) {
            Builder.addIf((Predicate)NOT_BLANK, this.excludes, values);
            return this;
        }

        public Builder exclude(String value, String ... values) {
            Builder.addIf((Predicate)NOT_BLANK, this.excludes, (Object)value, (Object[])values);
            return this;
        }

        public Builder include(Iterable<String> values) {
            Builder.addIf((Predicate)NOT_BLANK, this.includes, values);
            return this;
        }

        public Builder include(String value, String ... values) {
            Builder.addIf((Predicate)NOT_BLANK, this.includes, (Object)value, (Object[])values);
            return this;
        }
    }
}

