/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class TypeDetectingCopyOutputHandler
extends BaseOutputHandler
implements CommandOutputHandler<Void> {
    private static final int BUFFER_SIZE = 8192;
    private int bufferSize;
    private TypeAwareOutputSupplier outputSupplier;
    private String path;

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path) {
        this(outputSupplier, path, 8192);
    }

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path, int bufferSize) {
        this.bufferSize = Math.max(bufferSize, 8192);
        this.outputSupplier = outputSupplier;
        this.path = path;
    }

    public Void getOutput() {
        return null;
    }

    public void process(InputStream output) throws ProcessException {
        try (BufferedInputStream stream2 = new BufferedInputStream(output, this.bufferSize);){
            ((InputStream)stream2).mark(2);
            int read = ((InputStream)stream2).read();
            if (read == -1) {
                return;
            }
            ((InputStream)stream2).reset();
            String type = ContentDetectionUtils.detectContentType(stream2, this.path);
            if (type == null) {
                type = ContentDetectionUtils.isBinary(stream2, 8192) ? "application/octet-stream" : "text/plain";
            }
            try (OutputStream outputStream = this.outputSupplier.getStream(type);){
                IoUtils.copy((InputStream)stream2, (OutputStream)outputStream, (int)this.bufferSize);
            }
        }
        catch (InterruptedIOException stream2) {
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }
}

