/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.utils.process.BaseInputHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;

public class PathInputHandler
extends BaseInputHandler
implements CommandInputHandler {
    private final Path path;

    public PathInputHandler(@Nonnull Path path) {
        this.path = Objects.requireNonNull(path, "path");
    }

    public void process(@Nonnull @WillClose OutputStream outputStream) {
        try (OutputStream ignored = outputStream;){
            Files.copy(this.path, outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Input could not be copied from " + this.path.toAbsolutePath(), e);
        }
    }
}

