/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;

public abstract class LineReaderOutputHandler
extends BaseOutputHandler {
    private final Charset charset;
    private final LineReader.Mode newlineMode;

    protected LineReaderOutputHandler(Charset charset) {
        this(charset, LineReader.Mode.MODE_DETECT);
    }

    protected LineReaderOutputHandler(Charset charset, LineReader.Mode newlineMode) {
        this.charset = charset;
        this.newlineMode = newlineMode;
    }

    public void process(InputStream output) throws ProcessException {
        try (LineReader reader2 = this.createReader(output);){
            this.processReader(reader2);
        }
        catch (InterruptedIOException reader2) {
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    protected LineReader createReader(InputStream output) throws ProcessException {
        return new ReaderLineReader(this.newlineMode, new InputStreamReader((InputStream)new BufferedInputStream(output), this.charset));
    }

    protected abstract void processReader(LineReader var1) throws IOException;
}

