/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class ByteBufferInputStream
extends InputStream {
    private final ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void close() {
    }

    @Override
    public void mark(int ignored) {
        this.buffer.mark();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) {
        int remaining = this.buffer.remaining();
        if (remaining < 1) {
            return -1;
        }
        int read = Math.min(len, remaining);
        this.buffer.get(b, off, read);
        return read;
    }

    @Override
    public int read() {
        if (this.buffer.hasRemaining()) {
            return 0xFF & this.buffer.get();
        }
        return -1;
    }

    @Override
    public void reset() {
        this.buffer.reset();
    }

    @Override
    public long skip(long n) {
        if (n < 1L) {
            return n;
        }
        int skipped = Math.min((int)n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skipped);
        return skipped;
    }
}

