/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;

public class BatchingCommitCallback
implements CommitCallback {
    private final int batchSize;
    private final List<Commit> batch;
    private final CommitCallback delegate;

    public BatchingCommitCallback(CommitCallback delegate, int batchSize) {
        this.batchSize = batchSize;
        this.delegate = delegate;
        this.batch = Lists.newArrayListWithCapacity((int)batchSize);
    }

    public boolean onCommit(@Nonnull Commit commit) throws IOException {
        this.batch.add(commit);
        return this.flush(this.batch.size() >= this.batchSize);
    }

    public void onEnd(@Nonnull CommitSummary summary) throws IOException {
        this.flush(true);
        this.delegate.onEnd(summary);
    }

    public void onStart(@Nonnull CommitContext context) throws IOException {
        this.delegate.onStart(context);
    }

    protected boolean onCommits(@Nonnull Iterable<Commit> commits) throws IOException {
        for (Commit commit : commits) {
            if (this.delegate.onCommit(commit)) continue;
            return false;
        }
        return true;
    }

    private boolean flush(boolean now) throws IOException {
        if (now) {
            try {
                boolean bl = this.onCommits(this.batch);
                return bl;
            }
            finally {
                this.batch.clear();
            }
        }
        return true;
    }
}

