/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.ssh;

import com.atlassian.utils.process.Watchdog;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractSshStreamHandler {
    private Watchdog watchdog;

    public void complete() {
    }

    public void setWatchdog(Watchdog watchdog) {
        this.watchdog = watchdog;
    }

    protected void cancelProcess() {
        this.watchdog.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStream(InputStream inputStream, OutputStream outputStream, int bufferSize) throws IOException {
        boolean swallow = true;
        try {
            int n;
            byte[] buffer = new byte[bufferSize];
            while (-1 != (n = inputStream.read(buffer))) {
                this.resetWatchdog();
                outputStream.write(buffer, 0, n);
                outputStream.flush();
            }
            swallow = false;
        }
        finally {
            Closeables.close((Closeable)outputStream, (boolean)swallow);
        }
    }

    protected boolean isCanceled() {
        return this.watchdog.isCanceled();
    }

    protected void resetWatchdog() {
        if (this.watchdog != null) {
            this.watchdog.resetWatchdog();
        }
    }
}

