/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleRef
extends SimpleMinimalRef
implements Ref {
    private final String latestCommit;

    protected SimpleRef(@Nonnull AbstractRefBuilder<?, ?> builder, @Nonnull RefType refType) {
        super(builder, refType);
        this.latestCommit = ((AbstractRefBuilder)builder).latestCommit;
    }

    @Nonnull
    public String getLatestCommit() {
        return this.latestCommit;
    }

    @Nonnull
    protected String fieldsToString() {
        return super.fieldsToString() + ", latestCommit=" + this.getLatestCommit();
    }

    protected static abstract class AbstractRefBuilder<B extends AbstractRefBuilder<B, R>, R extends Ref>
    extends SimpleMinimalRef.AbstractMinimalRefBuilder<B, R> {
        private String latestCommit;

        protected AbstractRefBuilder() {
        }

        protected AbstractRefBuilder(@Nonnull R ref) {
            super(ref);
            this.latestCommit = ref.getLatestCommit();
        }

        @Nonnull
        public B latestCommit(@Nullable String value) {
            this.latestCommit = value;
            return (B)((Object)((AbstractRefBuilder)this.self()));
        }
    }

    public static class Builder
    extends AbstractRefBuilder<Builder, Ref> {
        private RefType type;

        public Builder() {
        }

        public Builder(Ref ref) {
            super(ref);
            this.type = ref.getType();
        }

        @Nonnull
        public SimpleRef build() {
            return new SimpleRef(this, this.type);
        }

        @Nonnull
        public Builder type(@Nonnull RefType value) {
            this.type = (RefType)Preconditions.checkNotNull((Object)value, (Object)"type");
            return this.self();
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

