/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.ContentDetectionUtils;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class TypeDetectingCopyOutputHandler
extends BaseOutputHandler
implements CommandOutputHandler<Void> {
    private static final int BUFFER_SIZE = 8192;
    private TypeAwareOutputSupplier outputSupplier;
    private int bufferSize;
    private String path;

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path) {
        this(outputSupplier, path, 1024);
    }

    public TypeDetectingCopyOutputHandler(TypeAwareOutputSupplier outputSupplier, String path, int bufferSize) {
        this.bufferSize = bufferSize;
        this.outputSupplier = outputSupplier;
        this.path = path;
    }

    public Void getOutput() {
        return null;
    }

    public void process(InputStream output) throws ProcessException {
        try {
            BufferedInputStream bufferedInput = new BufferedInputStream(output, 8192);
            String type = ContentDetectionUtils.detectContentType(bufferedInput, this.path);
            if (type == null) {
                type = ContentDetectionUtils.isBinary(bufferedInput, 8192) ? "application/octet-stream" : "text/plain";
            }
            OutputStream outputStream = this.outputSupplier.getStream(type);
            this.copyContent(bufferedInput, outputStream);
        }
        catch (InterruptedIOException bufferedInput) {
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    private void copyContent(BufferedInputStream output, OutputStream dest) throws IOException {
        int num;
        byte[] buffer = new byte[this.bufferSize];
        while ((num = output.read(buffer)) != -1) {
            this.resetWatchdog();
            dest.write(buffer, 0, num);
        }
    }
}

