/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.LineReader;
import com.atlassian.bitbucket.io.ReaderLineReader;
import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.function.Supplier;

public abstract class LineReaderOutputHandler
extends BaseOutputHandler {
    private final Supplier<Charset> charsetSupplier;
    private final LineReader.Mode newlineMode;

    @Deprecated
    public LineReaderOutputHandler(String charsetName) {
        this.charsetSupplier = () -> Charset.forName(charsetName);
        this.newlineMode = LineReader.Mode.MODE_DETECT;
    }

    protected LineReaderOutputHandler(Charset charset) {
        this(charset, LineReader.Mode.MODE_DETECT);
    }

    protected LineReaderOutputHandler(Charset charset, LineReader.Mode newlineMode) {
        this.newlineMode = newlineMode;
        this.charsetSupplier = () -> charset;
    }

    public void process(InputStream output) throws ProcessException {
        try (LineReader reader2 = this.createReader(output);){
            this.processReader(reader2);
        }
        catch (InterruptedIOException reader2) {
        }
        catch (IOException e) {
            throw new ProcessException((Throwable)e);
        }
    }

    protected LineReader createReader(InputStream output) throws ProcessException {
        InputStreamReader streamReader;
        try {
            streamReader = new InputStreamReader((InputStream)new BufferedInputStream(output), this.charsetSupplier.get());
        }
        catch (UnsupportedCharsetException e) {
            throw new ProcessException(e.getCharsetName() + " encoding is not supported", (Throwable)e);
        }
        return new ReaderLineReader(this.newlineMode, streamReader);
    }

    protected abstract void processReader(LineReader var1) throws IOException;

    protected String resetWatchdogAndReadLine(LineReader reader) throws IOException {
        this.resetWatchdog();
        return reader.readLine();
    }

    protected String resetWatchdogAndReadLine(LineReader reader, int maxLength) throws IOException {
        this.resetWatchdog();
        return reader.readLine(maxLength);
    }
}

