/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.utils.process.LineReadable;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

public abstract class LineReader
implements LineReadable {
    public static final int NEWLINE = 10;
    public static final int CARRIAGERETURN = 13;
    public static final int NULL = 0;
    private final StringBuilder buffer;
    private final Deque<String> lineBuffer;
    private Mode fileMode;
    private int readAhead;

    protected LineReader(Mode fileMode) {
        this.fileMode = fileMode;
        this.buffer = new StringBuilder();
        this.lineBuffer = new LinkedList<String>();
        this.readAhead = -1;
    }

    protected LineReader() {
        this(Mode.MODE_DETECT);
    }

    private boolean isEOL(int i) throws IOException {
        boolean isEOL;
        switch (this.fileMode) {
            case MODE_UNIX: {
                isEOL = i == 10;
                break;
            }
            case MODE_MAC: {
                isEOL = i == 13;
                break;
            }
            case MODE_PC: {
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i2);
                    isEOL = false;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_DETECT: {
                if (i == 10) {
                    this.fileMode = Mode.MODE_UNIX;
                    isEOL = true;
                    break;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        this.fileMode = Mode.MODE_PC;
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i2);
                    this.fileMode = Mode.MODE_MAC;
                    isEOL = true;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_MIXED: {
                if (i == 10) {
                    isEOL = true;
                    break;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 != 10) {
                        this.pushBack(i2);
                    }
                    isEOL = true;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_PC_UNIX_MIXED: {
                if (i == 10) {
                    isEOL = true;
                    break;
                }
                if (i == 13) {
                    int i2 = this.readNext();
                    if (i2 == 10) {
                        isEOL = true;
                        break;
                    }
                    this.pushBack(i2);
                    isEOL = false;
                    break;
                }
                isEOL = false;
                break;
            }
            case MODE_NULL: {
                isEOL = i == 0;
                break;
            }
            default: {
                isEOL = false;
            }
        }
        return isEOL;
    }

    public String readLine() throws IOException {
        if (this.lineBuffer.size() > 0) {
            return this.lineBuffer.pop();
        }
        this.buffer.setLength(0);
        int i = this.readNext();
        if (i == -1) {
            return null;
        }
        while (i != -1 && !this.isEOL(i)) {
            this.buffer.append((char)i);
            i = this.readNext();
        }
        return this.buffer.toString();
    }

    public String readLine(int maxLength) throws IOException {
        if (this.lineBuffer.size() > 0) {
            String line = this.lineBuffer.pop();
            if (line.length() > maxLength) {
                return line.substring(0, maxLength);
            }
            return line;
        }
        this.buffer.setLength(0);
        int i = this.readNext();
        if (i == -1) {
            return null;
        }
        while (i != -1 && !this.isEOL(i)) {
            if (this.buffer.length() < maxLength) {
                this.buffer.append((char)i);
            }
            i = this.readNext();
        }
        return this.buffer.toString();
    }

    public void pushLineBack(String line) {
        this.lineBuffer.push(line);
    }

    private int readNext() throws IOException {
        int ch;
        if (this.readAhead == -1) {
            ch = this.read();
        } else {
            ch = this.readAhead;
            this.readAhead = -1;
        }
        return ch;
    }

    private void pushBack(int ch) {
        this.readAhead = ch;
    }

    protected abstract int read() throws IOException;

    public static enum Mode {
        MODE_DETECT,
        MODE_UNIX,
        MODE_MAC,
        MODE_PC,
        MODE_MIXED,
        MODE_PC_UNIX_MIXED,
        MODE_NULL;

    }
}

