/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.File;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.OptionalLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleFile
extends File {
    private final String contentId;
    private final Path path;
    private final OptionalLong size;

    @Deprecated
    public SimpleFile(Path path, String contentId) {
        this.contentId = contentId;
        this.path = path;
        this.size = OptionalLong.empty();
    }

    private SimpleFile(Builder builder) {
        this.contentId = builder.contentId;
        this.path = builder.path;
        this.size = builder.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleFile) {
            SimpleFile f = (SimpleFile)((Object)o);
            return this.getPath().equals(f.getPath()) && Objects.equal((Object)this.getContentId(), (Object)f.getContentId());
        }
        return false;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    @Nonnull
    public OptionalLong getSize() {
        return this.size;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "SimpleFile{path='" + this.path + '\'' + ", contentId='" + this.contentId + '\'' + '}';
    }

    public static class Builder {
        private String contentId;
        private Path path;
        private OptionalLong size;

        public Builder() {
            this.size = OptionalLong.empty();
        }

        @Nonnull
        public Builder(@Nonnull File file) {
            this.contentId = ((File)Preconditions.checkNotNull((Object)file, (Object)"file")).getContentId();
            this.path = file.getPath();
            this.size = file.getSize();
        }

        @Nonnull
        public SimpleFile build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required.");
            return new SimpleFile(this);
        }

        @Nonnull
        public Builder contentId(@Nullable String value) {
            this.contentId = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value, (Object)"path");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value, (Object)"path")));
        }

        @Nonnull
        public Builder size(long value) {
            Preconditions.checkArgument((value > -1L ? 1 : 0) != 0, (Object)"File sizes may not be negative.");
            this.size = OptionalLong.of(value);
            return this;
        }
    }
}

