/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.property.PropertySupport;
import com.atlassian.bitbucket.property.SimplePropertySupport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;

public class SimpleDiff
extends SimplePropertySupport
implements Diff {
    private final boolean binary;
    private final Path destination;
    private final List<DiffHunk> hunks;
    private final Path source;
    private final boolean truncated;

    private SimpleDiff(Builder builder) {
        super((SimplePropertySupport.AbstractPropertyBuilder)builder);
        this.binary = builder.binary;
        this.destination = builder.destination;
        this.hunks = (List)Preconditions.checkNotNull((Object)builder.hunks.build(), (Object)"hunks");
        this.source = builder.source;
        this.truncated = builder.truncated;
    }

    public Path getDestination() {
        return this.destination;
    }

    @Nonnull
    public List<DiffHunk> getHunks() {
        return this.hunks;
    }

    public Path getSource() {
        return this.source;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder
    extends SimplePropertySupport.AbstractPropertyBuilder<Builder> {
        private final ImmutableList.Builder<DiffHunk> hunks = ImmutableList.builder();
        private boolean binary;
        private Path destination;
        private Path source;
        private boolean truncated;

        public Builder() {
        }

        public Builder(Diff diff) {
            super((PropertySupport)diff);
            this.binary = diff.isBinary();
            this.destination = diff.getDestination();
            this.source = diff.getSource();
            this.truncated = diff.isTruncated();
            List h = diff.getHunks();
            if (CollectionUtils.isNotEmpty((Collection)h)) {
                this.hunks.addAll((Iterable)h);
            }
        }

        public Builder binary(boolean value) {
            this.binary = value;
            return this;
        }

        public SimpleDiff build() {
            Preconditions.checkState((this.destination != null || this.source != null ? 1 : 0) != 0, (Object)"A destination or source path is required");
            return new SimpleDiff(this);
        }

        public Builder destination(@Nonnull Path value) {
            this.destination = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder destination(@Nonnull String value) {
            return this.destination((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }

        public Builder hunk(@Nonnull DiffHunk value) {
            this.hunks.add((Object)value);
            return this;
        }

        public Builder hunks(@Nonnull DiffHunk value, DiffHunk ... values) {
            this.hunks.add((Object)value).add((Object[])values);
            return this;
        }

        public Builder hunks(Iterable<DiffHunk> value) {
            if (value != null) {
                this.hunks.addAll(value);
            }
            return this;
        }

        public Builder source(@Nonnull Path value) {
            this.source = (Path)Preconditions.checkNotNull((Object)value);
            return this;
        }

        public Builder source(@Nonnull String value) {
            return this.source((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value)));
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

