/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.user.Person;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class SimpleBlame
implements Blame {
    private final Person author;
    private final Date authorTimestamp;
    private final String commitId;
    private final String displayCommitId;
    private final String fileName;
    private final int lineNumber;
    private final int spannedLines;

    private SimpleBlame(int lineNumber, int spannedLines, String commitId, String displayCommitId, String fileName, Person author, Date authorTimestamp) {
        this.author = author;
        this.authorTimestamp = authorTimestamp;
        this.commitId = commitId;
        this.displayCommitId = displayCommitId;
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.spannedLines = spannedLines;
    }

    public Person getAuthor() {
        return this.author;
    }

    public Date getAuthorTimestamp() {
        return this.authorTimestamp;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitDisplayId() {
        return this.displayCommitId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getSpannedLines() {
        return this.spannedLines;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.lineNumber);
        if (this.spannedLines > 1) {
            builder.append("-").append(this.lineNumber + this.spannedLines - 1);
        }
        builder.append(":").append(this.commitId).append(" ").append(this.author).append(" ").append(this.authorTimestamp).append(" (").append(this.fileName).append(")");
        return builder.toString();
    }

    public static final class Builder {
        private Person author;
        private Date authorTimestamp;
        private String commitId;
        private String displayCommitId;
        private String fileName;
        private int lineNumber;
        private int spannedLines;

        public Builder() {
        }

        public Builder(Blame blame) {
            this.author = blame.getAuthor();
            this.authorTimestamp = blame.getAuthorTimestamp();
            this.commitId = blame.getCommitId();
            this.displayCommitId = blame.getCommitDisplayId();
            this.fileName = blame.getFileName();
            this.lineNumber = blame.getLineNumber();
            this.spannedLines = blame.getSpannedLines();
        }

        public Builder author(Person value) {
            this.author = value;
            return this;
        }

        public Builder authorTimestamp(Date value) {
            this.authorTimestamp = value;
            return this;
        }

        public SimpleBlame build() {
            Preconditions.checkArgument((this.lineNumber > 0 ? 1 : 0) != 0, (Object)"Line numbers begin at 1 and are required");
            Preconditions.checkArgument((this.author.getName() != null && this.authorTimestamp != null ? 1 : 0) != 0, (Object)"Author information (name and timestamp) is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.commitId), (Object)"A commit hash is required");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.fileName), (Object)"A filename is required");
            if (this.displayCommitId == null) {
                this.displayCommitId = this.commitId.substring(0, 11);
            }
            if (this.spannedLines < 1) {
                this.spannedLines = 1;
            }
            return new SimpleBlame(this.lineNumber, this.spannedLines, this.commitId, this.displayCommitId, this.fileName, this.author, this.authorTimestamp);
        }

        public Builder commitId(String value) {
            this.commitId = value;
            return this;
        }

        public Builder fileName(String value) {
            this.fileName = value;
            return this;
        }

        public Builder lineNumber(int value) {
            this.lineNumber = value;
            return this;
        }

        public Builder spannedLines(int value) {
            this.spannedLines = value;
            return this;
        }
    }
}

