/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.InvalidNameException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mail.NoMailHostConfigurationException;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.ConflictException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.user.RestDetailedGroup;
import com.atlassian.bitbucket.rest.user.RestDetailedUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.DetailedGroup;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.user.CommonJsonObjects;
import com.atlassian.stash.internal.rest.user.Validators;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Collections;
import javax.validation.Validator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="admin")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UserAdminResource
extends RestResource {
    private final UserAdminService userAdminService;
    private final Validator validator;

    public UserAdminResource(I18nService i18nService, UserAdminService userAdminService, Validator validator) {
        super(i18nService);
        this.userAdminService = userAdminService;
        this.validator = validator;
    }

    @GET
    @Path(value="users")
    public Response getUsers(@QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.userAdminService.findUsersByName(filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedUser>(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @POST
    @Path(value="users")
    public Response createUser(@QueryParam(value="name") String username, @QueryParam(value="password") String password, @QueryParam(value="displayName") String displayName, @QueryParam(value="emailAddress") String emailAddress, @QueryParam(value="addToDefaultGroup") @DefaultValue(value="true") boolean addToDefaultGroup, @QueryParam(value="notify") String notify) {
        boolean sendPasswordResetEmail;
        boolean bl = sendPasswordResetEmail = notify != null && !"false".equalsIgnoreCase(notify);
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        if (!sendPasswordResetEmail && StringUtils.isEmpty((CharSequence)password)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.password", new Object[0]);
            throw new BadRequestException(message);
        }
        if (StringUtils.isEmpty((CharSequence)displayName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.displayname", new Object[0]);
            throw new BadRequestException(message);
        }
        if (StringUtils.isEmpty((CharSequence)emailAddress)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.create.no.email", new Object[0]);
            throw new BadRequestException(message);
        }
        if (sendPasswordResetEmail) {
            try {
                this.userAdminService.createUserWithGeneratedPassword(username, displayName, emailAddress);
            }
            catch (NoMailHostConfigurationException e) {
                String message = this.i18nService.getMessage("bitbucket.service.user.create.no.mail.server", new Object[0]);
                throw new ConflictException(message);
            }
        } else {
            this.userAdminService.createUser(username, password, displayName, emailAddress, addToDefaultGroup);
        }
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="users")
    public Response deleteUser(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.delete.no.username", new Object[0]);
            throw new BadRequestException(message);
        }
        DetailedUser user = this.userAdminService.deleteUser(username);
        return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
    }

    @PUT
    @Path(value="users")
    public Response updateUserDetails(CommonJsonObjects.UserUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            DetailedUser user = this.userAdminService.updateUser(update.getName(), update.getDisplayName(), update.getEmail());
            return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @POST
    @Path(value="users/rename")
    public Response renameUser(CommonJsonObjects.UserRename rename) {
        Validators.validateConstraints(this.validator, rename);
        try {
            DetailedUser user = this.userAdminService.renameUser(rename.getName(), rename.getNewName());
            return ResponseFactory.ok(RestDetailedUser.REST_TRANSFORM.apply(user)).build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.rename.notAuthorised", new Object[0]));
        }
    }

    @PUT
    @Path(value="users/credentials")
    public Response updateUserPassword(CommonJsonObjects.AdminPasswordUpdate update) {
        Validators.validateConstraints(this.validator, update);
        try {
            this.userAdminService.updatePassword(update.getName(), update.getPassword());
            return ResponseFactory.noContent().build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @DELETE
    @Path(value="users/captcha")
    public Response clearUserCaptchaChallenge(@QueryParam(value="name") String username) {
        if (StringUtils.isEmpty((CharSequence)username) || username.length() > 255) {
            throw new InvalidNameException(this.i18nService.createKeyedMessage("bitbucket.bad.user.name", new Object[0]));
        }
        try {
            this.userAdminService.clearCaptchaChallenge(username);
            return ResponseFactory.noContent().build();
        }
        catch (AuthorisationException e) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.rest.user.update.notAuthorised", new Object[0]));
        }
    }

    @GET
    @Path(value="groups")
    public Response getGroups(@QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.userAdminService.findGroupsByName(filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedGroup>(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    @POST
    @Path(value="groups")
    public Response createGroup(@QueryParam(value="name") String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName) || groupName.length() > 255) {
            throw new InvalidNameException(this.i18nService.createKeyedMessage("bitbucket.bad.group.name", new Object[0]));
        }
        DetailedGroup group = this.userAdminService.createGroup(groupName);
        return ResponseFactory.ok(RestDetailedGroup.REST_TRANSFORM.apply(group)).build();
    }

    @DELETE
    @Path(value="groups")
    public Response deleteGroup(@QueryParam(value="name") String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.delete.no.groupname", new Object[0]);
            throw new BadRequestException(message);
        }
        DetailedGroup group = this.userAdminService.deleteGroup(groupName);
        return ResponseFactory.ok(RestDetailedGroup.REST_TRANSFORM.apply(group)).build();
    }

    @Deprecated
    @POST
    @Path(value="groups/add-user")
    public Response addUserToGroup(CommonJsonObjects.UserPickerContext data) {
        String groupName = data.getContext();
        String username = data.getItemName();
        return this.addUserToGroup(groupName, username);
    }

    @Deprecated
    @POST
    @Path(value="users/add-group")
    public Response addGroupToUser(CommonJsonObjects.UserPickerContext data) {
        String groupName = data.getItemName();
        String userName = data.getContext();
        return this.addUserToGroup(groupName, userName);
    }

    @POST
    @Path(value="groups/add-users")
    public Response addUsersToGroup(CommonJsonObjects.GroupAndUsers data) {
        this.userAdminService.addMembersToGroup(data.getGroup(), data.getUsers());
        return ResponseFactory.ok().build();
    }

    private Response addUserToGroup(String groupName, String username) {
        this.userAdminService.addUserToGroups(username, Collections.singleton(groupName));
        return ResponseFactory.ok().build();
    }

    @POST
    @Path(value="users/add-groups")
    public Response addUserToGroups(CommonJsonObjects.UserAndGroups data) {
        this.userAdminService.addUserToGroups(data.getUser(), data.getGroups());
        return ResponseFactory.ok().build();
    }

    @POST
    @Path(value="groups/remove-user")
    public Response removeUserFromGroup(CommonJsonObjects.UserPickerContext data) {
        String groupName = data.getContext();
        String username = data.getItemName();
        return this.removeUserFromGroup(groupName, username);
    }

    @POST
    @Path(value="users/remove-group")
    public Response removeGroupFromUser(CommonJsonObjects.UserPickerContext data) {
        String groupName = data.getItemName();
        String username = data.getContext();
        return this.removeUserFromGroup(groupName, username);
    }

    private Response removeUserFromGroup(String groupName, String userName) {
        this.userAdminService.removeUserFromGroup(groupName, userName);
        return ResponseFactory.ok().build();
    }

    @GET
    @Path(value="groups/more-members")
    public Response findUsersInGroup(@QueryParam(value="context") String groupName, @QueryParam(value="filter") @DefaultValue(value="") String filter, @Context PageRequest pageRequest) {
        this.checkContext(groupName);
        Page page = this.userAdminService.findUsersWithGroup(groupName, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedUser>(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="groups/more-non-members")
    public Response findUsersNotInGroup(@QueryParam(value="context") String groupName, @QueryParam(value="filter") @DefaultValue(value="") String filter, @Context PageRequest pageRequest) {
        this.checkContext(groupName);
        Page page = this.userAdminService.findUsersWithoutGroup(groupName, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedUser>(page, RestDetailedUser.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="users/more-members")
    public Response findGroupsForUser(@QueryParam(value="context") String username, @QueryParam(value="filter") @DefaultValue(value="") String filter, @Context PageRequest pageRequest) {
        this.checkContext(username);
        Page page = this.userAdminService.findGroupsWithUser(username, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedGroup>(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="users/more-non-members")
    public Response findOtherGroupsForUser(@QueryParam(value="context") String username, @QueryParam(value="filter") @DefaultValue(value="") String filter, @Context PageRequest pageRequest) {
        this.checkContext(username);
        Page page = this.userAdminService.findGroupsWithoutUser(username, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedGroup>(page, RestDetailedGroup.REST_TRANSFORM)).build();
    }

    private void checkContext(String groupName) {
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            String message = this.i18nService.getMessage("bitbucket.service.user.members.no.context", new Object[0]);
            throw new BadRequestException(message);
        }
    }
}

