/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionAdminService;
import com.atlassian.bitbucket.permission.SetPermissionRequest;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.permission.RestPermitted;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.user.RestDetailedGroup;
import com.atlassian.bitbucket.rest.user.RestPermittedGroup;
import com.atlassian.bitbucket.rest.user.RestPermittedUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.user.AbstractPermissionResource;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousAllowed
public class ProjectPermissionResource
extends AbstractPermissionResource {
    public ProjectPermissionResource(PermissionAdminService permissionAdminService, UserService userService, I18nService i18nService) {
        super(i18nService, permissionAdminService, userService);
    }

    @GET
    @Path(value="groups")
    public Response getGroupsWithAnyPermission(@Context Project project, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findGroupsWithProjectPermission(project, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestPermittedGroup>(page, RestPermittedGroup.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="groups/none")
    public Response getGroupsWithoutAnyPermission(@Context Project project, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findGroupsWithoutProjectPermission(project, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestDetailedGroup>(page, RestDetailedGroup.NAME_TRANSFORM)).build();
    }

    @GET
    @Path(value="users")
    public Response getUsersWithAnyPermission(@Context Project project, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findUsersWithProjectPermission(project, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestPermittedUser>(page, RestPermittedUser.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="users/none")
    public Response getUsersWithoutPermission(@Context Project project, @QueryParam(value="filter") String filter, @Context PageRequest pageRequest) {
        Page page = this.permissionAdminService.findLicensedUsersWithoutProjectPermission(project, filter, pageRequest);
        return ResponseFactory.ok(new RestPage<RestApplicationUser>(page, RestApplicationUser.REST_TRANSFORM)).build();
    }

    @PUT
    @Path(value="groups")
    public Response setPermissionForGroups(@Context Project project, @QueryParam(value="permission") String permissionName, @QueryParam(value="name") Set<String> groupNames) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        Set<String> groups = this.validateGroups(groupNames, false);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().projectPermission(permission, project).groups(groups).build());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="users")
    public Response setPermissionForUsers(@Context Project project, @QueryParam(value="name") Set<String> usernames, @QueryParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        Set<ApplicationUser> users = this.validateUsers(usernames, false);
        this.permissionAdminService.setPermission(new SetPermissionRequest.Builder().projectPermission(permission, project).users(users).build());
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="groups")
    public Response revokePermissionsForGroup(@Context Project project, @QueryParam(value="name") String groupName) {
        groupName = this.validateGroup(groupName, true);
        this.permissionAdminService.revokeAllProjectPermissions(project, groupName);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="users")
    public Response revokePermissionsForUser(@Context Project project, @QueryParam(value="name") String username) {
        ApplicationUser user = this.validateUser(username, true);
        this.permissionAdminService.revokeAllProjectPermissions(project, user);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{permission}/all")
    public Response hasAllUserPermission(@Context Project project, @PathParam(value="permission") String permissionName) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        return ResponseFactory.ok(new RestPermitted(this.permissionAdminService.hasAllProjectPermission(permission, project))).build();
    }

    @POST
    @Path(value="{permission}/all")
    public Response modifyAllUserPermission(@Context Project project, @PathParam(value="permission") String permissionName, @QueryParam(value="allow") Boolean allow) {
        Permission permission = this.validatePermission(permissionName, Project.class);
        if (allow == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.permissionadmin.invalidallow", new Object[0]);
            throw new BadRequestException(message);
        }
        if (allow.booleanValue()) {
            this.permissionAdminService.grantAllProjectPermission(permission, project);
        } else {
            this.permissionAdminService.revokeAllProjectPermission(permission, project);
        }
        return ResponseFactory.noContent().build();
    }
}

