/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.rest.user.ExampleDetailedUser;
import com.atlassian.bitbucket.validation.annotation.FieldEquals;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.collect.Sets;
import java.security.Principal;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.hibernate.validator.constraints.Email;

public final class CommonJsonObjects {
    public static final UserPickerContext USER_GROUP_PICKER_CONTEXT_EXAMPLE = new UserPickerContext("user_a", "group_a");
    public static final UserPickerContext GROUP_USER_PICKER_CONTEXT_EXAMPLE = new UserPickerContext("group_a", "user_a");
    public static final UserAndGroups USER_AND_GROUPS_EXAMPLE = new UserAndGroups("user", "group_a", "group_b");
    public static final GroupAndUsers GROUP_AND_USERS_EXAMPLE = new GroupAndUsers("group", "user1", "user2");
    public static final UserRename USER_RENAME_EXAMPLE = new UserRename(ExampleDetailedUser.EXAMPLE.getName(), ExampleDetailedUser.EXAMPLE.getName() + "-new");
    public static final UserUpdate USER_UPDATE_EXAMPLE = new UserUpdate(ExampleDetailedUser.EXAMPLE.getName(), ExampleDetailedUser.EXAMPLE.getDisplayName(), ExampleDetailedUser.EXAMPLE.getEmailAddress());
    public static final UserPasswordUpdate USER_PASSWORD_UPDATE_EXAMPLE = new UserPasswordUpdate("faithless", "secret", "secret");
    public static final AdminPasswordUpdate ADMIN_PASSWORD_UPDATE_EXAMPLE = new AdminPasswordUpdate(ExampleDetailedUser.EXAMPLE.getName(), "secret", "secret");

    @JsonSerialize
    public static class AdminPasswordUpdate
    extends PasswordUpdate {
        @JsonProperty
        private final String name;

        protected AdminPasswordUpdate() {
            super(null, null);
            this.name = null;
        }

        public AdminPasswordUpdate(String name, String password, String passwordConfirm) {
            super(password, passwordConfirm);
            this.name = name;
        }

        @RequiredString(size=255)
        public String getName() {
            return this.name;
        }
    }

    @JsonSerialize
    public static class UserPasswordUpdate
    extends PasswordUpdate {
        @JsonProperty
        private final String oldPassword;

        protected UserPasswordUpdate() {
            super(null, null);
            this.oldPassword = null;
        }

        public UserPasswordUpdate(String oldPassword, String password, String passwordConfirm) {
            super(password, passwordConfirm);
            this.oldPassword = oldPassword;
        }

        @RequiredString(size=255)
        public String getOldPassword() {
            return this.oldPassword;
        }
    }

    @JsonSerialize
    @FieldEquals(fields={"password", "passwordConfirm"}, reportingField="passwordConfirm", message="{com.atlassian.bitbucket.validation.passwords.notequals.message}")
    static class PasswordUpdate {
        @JsonProperty
        private final String password;
        @JsonProperty
        private final String passwordConfirm;

        protected PasswordUpdate() {
            this(null, null);
        }

        public PasswordUpdate(String password, String passwordConfirm) {
            this.password = password;
            this.passwordConfirm = passwordConfirm;
        }

        @RequiredString(size=255)
        public String getPassword() {
            return this.password;
        }

        @RequiredString(size=255)
        public String getPasswordConfirm() {
            return this.passwordConfirm;
        }
    }

    @JsonSerialize
    public static class UserRename
    implements Principal {
        @JsonProperty
        private String name;
        @JsonProperty
        private String newName;

        protected UserRename() {
            this.name = null;
            this.newName = null;
        }

        private UserRename(String name, String newName) {
            this.name = name;
            this.newName = newName;
        }

        @Override
        @RequiredString(size=255)
        public String getName() {
            return this.name;
        }

        @RequiredString(size=255)
        public String getNewName() {
            return this.newName;
        }
    }

    @JsonSerialize
    public static class GroupAndUsers {
        @JsonProperty
        private String group;
        @JsonProperty
        private Set<String> users;

        protected GroupAndUsers() {
            this.group = null;
            this.users = null;
        }

        public GroupAndUsers(String group, String ... users) {
            this.group = group;
            this.users = Sets.newHashSet((Object[])users);
        }

        @RequiredString(size=255)
        public String getGroup() {
            return this.group;
        }

        @NotNull
        public Set<String> getUsers() {
            return this.users;
        }
    }

    @JsonSerialize
    public static class UserAndGroups {
        @JsonProperty
        private String user;
        @JsonProperty
        private Set<String> groups;

        protected UserAndGroups() {
            this.user = null;
            this.groups = null;
        }

        public UserAndGroups(String user, String ... groups) {
            this.user = user;
            this.groups = Sets.newHashSet((Object[])groups);
        }

        @RequiredString(size=255)
        public String getUser() {
            return this.user;
        }

        @NotNull
        public Set<String> getGroups() {
            return this.groups;
        }
    }

    @JsonSerialize
    public static class UserUpdate
    implements Principal {
        @JsonProperty
        private final String name;
        @JsonProperty
        private final String displayName;
        @JsonProperty
        private final String email;

        protected UserUpdate() {
            this(null, null, null);
        }

        public UserUpdate(String name, String displayName, String email) {
            this.name = name;
            this.displayName = displayName;
            this.email = email;
        }

        @Override
        @RequiredString(size=255)
        public String getName() {
            return this.name;
        }

        @RequiredString(size=255)
        public String getDisplayName() {
            return this.displayName;
        }

        @Email
        @RequiredString(size=255)
        public String getEmail() {
            return this.email;
        }
    }

    @JsonSerialize
    public static class UserPickerContext {
        @JsonProperty
        private final String context;
        @JsonProperty
        private final String itemName;

        protected UserPickerContext() {
            this(null, null);
        }

        public UserPickerContext(String context, String itemName) {
            this.context = context;
            this.itemName = itemName;
        }

        public String getContext() {
            return this.context;
        }

        public String getItemName() {
            return this.itemName;
        }
    }
}

