/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCreateRequest;
import com.atlassian.bitbucket.repository.RepositoryForkRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.RepositoryUpdateRequest;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Iterables;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RepositoryResource
extends RestResource {
    private static final Pattern PATTERN_LOCATION = Pattern.compile("(.+projects/)([^/]+)(/repos/)(.+)$");
    private static final Logger log = LoggerFactory.getLogger(RepositoryResource.class);
    private final ProjectService projectService;
    private final RepositoryService repositoryService;
    private final ScmService scmService;
    public static final RestErrorMessage DELETION_SCHEDULED_EXAMPLE = new RestErrorMessage("Repository scheduled for deletion.");

    public RepositoryResource(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService, ScmService scmService) {
        super(i18nService);
        this.projectService = projectService;
        this.repositoryService = repositoryService;
        this.scmService = scmService;
    }

    @POST
    public Response createRepository(@Context Project project, @Context UriInfo uriInfo, RestRepository restRepository) {
        String name = restRepository.getName();
        if (name == null) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.noreponame", new Object[0]));
        }
        String scmId = restRepository.getScmId();
        if (StringUtils.isBlank((CharSequence)scmId)) {
            Set scms = this.scmService.getAvailable();
            if (scms.size() == 1) {
                scmId = ((AvailableScm)Iterables.getOnlyElement((Iterable)scms)).getId();
                log.debug("{}: No SCM was supplied; defaulting to {}", (Object)name, (Object)scmId);
            } else {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.noscm", new Object[]{Iterables.toString((Iterable)Iterables.transform((Iterable)scms, AvailableScm::getId))}));
            }
        }
        RepositoryCreateRequest request = ((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)((RepositoryCreateRequest.Builder)new RepositoryCreateRequest.Builder().forkable(restRepository.isForkable())).name(name)).project(project).scmId(scmId).publiclyAccessible(restRepository.isPublic())).build();
        Repository repository = this.repositoryService.create(request);
        URI repoURI = uriInfo.getRequestUriBuilder().path(repository.getSlug()).build(new Object[0]);
        return ResponseFactory.created(repoURI).entity((Object)this.transform(repository)).build();
    }

    @DELETE
    @Path(value="{repositorySlug}")
    public Response deleteRepository(@PathParam(value="projectKey") String projectKey, @PathParam(value="repositorySlug") String repositorySlug) {
        Repository repository = this.repositoryService.getBySlug(projectKey, repositorySlug);
        if (repository == null) {
            return ResponseFactory.noContent().build();
        }
        this.repositoryService.delete(repository);
        return ResponseFactory.status(Response.Status.ACCEPTED).entity((Object)new RestErrorMessage(this.i18nService.getMessage("bitbucket.rest.repository.deletionscheduled", new Object[0]))).build();
    }

    @POST
    @Path(value="{repositorySlug}")
    public Response forkRepository(@Context Repository repository, @Context UriInfo uriInfo, RestRepository restFork) {
        String scmId = restFork.getScmId();
        if (scmId != null && !scmId.equals(repository.getScmId())) {
            String message = this.i18nService.getMessage("bitbucket.rest.repository.forkwithtype", new Object[0]);
            throw new BadRequestException(message);
        }
        RestProject project = restFork.getProject();
        if (project != null) {
            String projectKey = project.getKey();
            if (StringUtils.isBlank((CharSequence)projectKey)) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.fork.missingprojectkey", new Object[0]));
            }
            project = this.projectService.getByKey(projectKey);
            if (project == null) {
                throw new NoSuchProjectException(this.i18nService.createKeyedMessage("bitbucket.rest.repository.fork.nosuchproject", new Object[]{projectKey}));
            }
        }
        RepositoryForkRequest request = ((RepositoryForkRequest.Builder)new RepositoryForkRequest.Builder(repository).forkable(restFork.isForkable())).name(restFork.getName()).project((Project)project).build();
        return this.created(this.repositoryService.fork(request), uriInfo);
    }

    @GET
    @Path(value="{repositorySlug}/forks")
    public Response getForkedRepositories(@Context Repository repository, @Context PageRequest pageRequest) {
        Page page = this.repositoryService.findByOrigin(repository, pageRequest);
        return ResponseFactory.ok(new RestPage<RestRepository>(page, RestRepository.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="{repositorySlug}/related")
    public Response getRelatedRepositories(@Context Repository repository, @Context PageRequest pageRequest) {
        Page page = this.repositoryService.findRelated(repository, pageRequest);
        return ResponseFactory.ok(new RestPage<RestRepository>(page, RestRepository.REST_TRANSFORM)).build();
    }

    @GET
    public Response getRepositories(@PathParam(value="projectKey") String projectKey, @Context PageRequest pageRequest) {
        Page page = this.repositoryService.findByProjectKey(projectKey, pageRequest);
        return ResponseFactory.ok(new RestPage<RestRepository>(page, RestRepository.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="{repositorySlug}")
    public Response getRepository(@Context Repository repository) {
        return ResponseFactory.ok(this.transform(repository)).build();
    }

    @POST
    @Path(value="{repositorySlug}/recreate")
    public Response retryCreateRepository(@Context Repository repository) {
        return ResponseFactory.ok(this.transform(this.repositoryService.retryCreate(repository))).build();
    }

    @PUT
    @Path(value="{repositorySlug}")
    public Response updateRepository(@Context Repository repository, @Context UriInfo uriInfo, RestRepository restRepository) {
        if (restRepository.getScmId() != null && !restRepository.getScmId().equals(repository.getScmId())) {
            String message = this.i18nService.getMessage("bitbucket.rest.repository.nochangetype", new Object[0]);
            throw new BadRequestException("scmId", message);
        }
        String slug = repository.getSlug();
        String projectKey = repository.getProject().getKey();
        RepositoryUpdateRequest.Builder builder = new RepositoryUpdateRequest.Builder(repository);
        if (!StringUtils.isBlank((CharSequence)restRepository.getName())) {
            builder = (RepositoryUpdateRequest.Builder)builder.name(restRepository.getName());
        }
        if (restRepository.hasForkable()) {
            builder = (RepositoryUpdateRequest.Builder)builder.forkable(restRepository.isForkable());
        }
        if (restRepository.hasPublic()) {
            builder = (RepositoryUpdateRequest.Builder)builder.publiclyAccessible(restRepository.isPublic());
        }
        if (restRepository.hasProject()) {
            builder = builder.project(this.projectService.getByKey(restRepository.getProject().getKey()));
        }
        if (slug.equals((repository = this.repositoryService.update(builder.build())).getSlug()) && projectKey.equals(repository.getProject().getKey())) {
            return ResponseFactory.ok(this.transform(repository)).build();
        }
        return this.created(repository, uriInfo);
    }

    private Response created(Repository repository, UriInfo uriInfo) {
        String requestPath = uriInfo.getRequestUri().getPath();
        Matcher matcher = PATTERN_LOCATION.matcher(requestPath);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("The request path, " + requestPath + ", is not understood");
        }
        String location = matcher.group(1) + repository.getProject().getKey() + matcher.group(3) + repository.getSlug();
        return ResponseFactory.created(uriInfo.getRequestUriBuilder().replacePath(location).build(new Object[0])).entity((Object)this.transform(repository)).build();
    }

    private RestRepository transform(Repository repository) {
        return new RestRepository(repository, true);
    }
}

