/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.NotFoundException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.hook.repository.RestRepositoryHook;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.setting.Settings;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/settings/hooks")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RepositoryHookResource
extends RestResource {
    private final RepositoryHookService repositoryHookService;

    public RepositoryHookResource(I18nService i18nService, RepositoryHookService repositoryHookService) {
        super(i18nService);
        this.repositoryHookService = repositoryHookService;
    }

    @GET
    public Response getRepositoryHooks(@Context Repository repository, @DefaultValue(value="") @QueryParam(value="type") String typeAsString, @Context PageRequest pageRequest) {
        Page page;
        if (StringUtils.isEmpty((CharSequence)typeAsString)) {
            page = this.repositoryHookService.findAll(repository, pageRequest);
        } else {
            RepositoryHookType type;
            try {
                type = RepositoryHookType.valueOf((String)typeAsString);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.hook.bad.type", new Object[]{typeAsString}));
            }
            page = this.repositoryHookService.findByType(repository, type, pageRequest);
        }
        return ResponseFactory.ok(new RestPage<RestRepositoryHook>(page, RestRepositoryHook.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="{hookKey}")
    public Response getRepositoryHook(@Context Repository repository, @PathParam(value="hookKey") String hookKey) {
        RepositoryHook descriptor = this.getHookByKey(repository, hookKey);
        return ResponseFactory.ok(RestRepositoryHook.REST_TRANSFORM.apply(descriptor)).build();
    }

    private RepositoryHook getHookByKey(Repository repository, String hookKey) {
        RepositoryHook descriptor = this.repositoryHookService.getByKey(repository, hookKey);
        if (descriptor == null) {
            throw new NotFoundException(this.i18nService.getMessage("bitbucket.rest.nosuchrepositoryhook", new Object[]{hookKey}));
        }
        return descriptor;
    }

    @PUT
    @Path(value="{hookKey}/enabled")
    public Response enableHook(@Context Repository repository, @PathParam(value="hookKey") String hookKey, @HeaderParam(value="Content-Length") @DefaultValue(value="0") int contentLength, @Context ContainerRequest request) {
        Map rawSettings = contentLength > 0 ? (Map)request.getEntity(Map.class) : null;
        RepositoryHook descriptor = rawSettings != null ? this.repositoryHookService.enable(repository, hookKey, this.createSettings(rawSettings)) : this.repositoryHookService.enable(repository, hookKey);
        return ResponseFactory.ok(RestRepositoryHook.REST_TRANSFORM.apply(descriptor)).build();
    }

    @DELETE
    @Path(value="{hookKey}/enabled")
    public Response disableHook(@Context Repository repository, @PathParam(value="hookKey") String hookKey) {
        RepositoryHook descriptor = this.repositoryHookService.disable(repository, hookKey);
        return ResponseFactory.ok(RestRepositoryHook.REST_TRANSFORM.apply(descriptor)).build();
    }

    @GET
    @Path(value="{hookKey}/settings")
    public Response getSettings(@Context Repository repository, @PathParam(value="hookKey") String hookKey) {
        Settings settings = this.repositoryHookService.getSettings(repository, hookKey);
        if (settings == null) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.ok(settings.asMap()).build();
    }

    @PUT
    @Path(value="{hookKey}/settings")
    public Response setSettings(@Context Repository repository, @PathParam(value="hookKey") String hookKey, Map<String, Object> rawSettings) throws IOException {
        Settings settings = this.createSettings(rawSettings);
        settings = this.repositoryHookService.setSettings(repository, hookKey, settings);
        return ResponseFactory.ok(settings.asMap()).build();
    }

    private Settings createSettings(Map<String, Object> rawSettings) {
        try {
            return this.repositoryHookService.createSettingsBuilder().addAll(rawSettings).build();
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.repository.settings.malformed", new Object[0]));
        }
    }
}

