/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.CreateBranchRequest;
import com.atlassian.bitbucket.repository.MetadataMap;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefMetadataRequest;
import com.atlassian.bitbucket.repository.RefOrder;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.rest.repository.RestBranch;
import com.atlassian.bitbucket.rest.repository.RestMetadataMap;
import com.atlassian.bitbucket.rest.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.json.marshal.JsonableMarshaller;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.annotations.OptionalContext;
import com.atlassian.stash.internal.rest.repository.AbstractRepositoryRefResource;
import com.atlassian.stash.internal.rest.repository.RestCreateBranchRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Map;
import java.util.function.Function;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/branches")
@Singleton
@AnonymousAllowed
public class BranchResource
extends AbstractRepositoryRefResource {
    private final I18nService i18nService;
    private final JsonableMarshaller jsonableMarshaller;

    public BranchResource(RefService refService, I18nService i18nService, JsonableMarshaller jsonableMarshaller) {
        super(refService);
        this.i18nService = i18nService;
        this.jsonableMarshaller = jsonableMarshaller;
    }

    @POST
    public Response createBranch(@Context Repository repository, RestCreateBranchRequest restRequest) {
        return this.process(repository, (repo, refService) -> new RestBranch(refService.createBranch(((CreateBranchRequest.Builder)new CreateBranchRequest.Builder(repo, restRequest.getName(), restRequest.getStartPoint()).message(restRequest.getMessage())).build())));
    }

    @GET
    public Response getBranches(@Context Repository repository, final @Context PageRequest pageRequest, final @QueryParam(value="base") String baseRefId, final @QueryParam(value="details") boolean details, final @QueryParam(value="filterText") String filterText, final @QueryParam(value="orderBy") String orderBy, final @OptionalContext Map<String, Object> context) {
        return this.process(repository, new AbstractRepositoryRefResource.RepositoryCallback(){

            @Override
            public RestPage<? extends RestMinimalRef> doWithRepository(Repository repository, RefService refService) {
                RepositoryBranchesRequest request = ((RepositoryBranchesRequest.Builder)((RepositoryBranchesRequest.Builder)new RepositoryBranchesRequest.Builder(repository).filterText(filterText)).order(RefOrder.fromValueOrNull((String)orderBy))).build();
                Page branches = refService.getBranches(request, pageRequest);
                Function restTransformer = RestBranch.REST_TRANSFORM;
                if (details && branches.getSize() > 0) {
                    Ref baseRef = refService.resolveRef(repository, baseRefId);
                    if (baseRef == null) {
                        throw new NoSuchEntityException(BranchResource.this.i18nService.createKeyedMessage("bitbucket.rest.branches.error.invalidBaseRef", new Object[]{baseRefId, repository.getName()}));
                    }
                    Map metadataByRef = refService.getMetadataByRefs(new RefMetadataRequest.Builder().baseRef(baseRef).repository(repository).refs(branches.getValues()).context(context).build());
                    restTransformer = BranchResource.this.toRestBranchWithMetadata(metadataByRef);
                }
                return new RestPage<RestBranch>(branches, restTransformer);
            }
        });
    }

    @GET
    @Path(value="default")
    public Response getDefaultBranch(@Context Repository repository) {
        return this.process(repository, new AbstractRepositoryRefResource.RepositoryCallback(){

            @Override
            public RestBranch doWithRepository(Repository repository, RefService refService) {
                Branch defaultBranch = refService.getDefaultBranch(repository);
                return new RestBranch(defaultBranch);
            }
        });
    }

    @PUT
    @Path(value="default")
    public Response setDefaultBranch(@Context Repository repository, final RestBranch branch) {
        return this.process(repository, new AbstractRepositoryRefResource.RepositoryCallback(){

            public Response.ResponseBuilder doWithRepository(Repository repository, RefService refService) {
                refService.setDefaultBranch(repository, branch.getId());
                return ResponseFactory.noContent();
            }
        });
    }

    private Function<Branch, RestBranch> toRestBranchWithMetadata(Map<Ref, MetadataMap> metadataByRef) {
        return branch -> {
            RestBranch restBranch = new RestBranch((Branch)branch);
            MetadataMap metadataMap = (MetadataMap)metadataByRef.get(branch);
            restBranch.put("metadata", metadataMap != null ? new RestMetadataMap(metadataMap, this.jsonableMarshaller) : new RestMetadataMap());
            return restBranch;
        };
    }
}

