/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public abstract class AbstractRepositoryRefResource {
    private final RefService refService;

    public AbstractRepositoryRefResource(RefService refService) {
        this.refService = refService;
    }

    protected Response process(Repository repository, RepositoryCallback callback) {
        Object body = callback.doWithRepository(repository, this.refService);
        if (body == null) {
            return ResponseFactory.status(Response.Status.NOT_FOUND).build();
        }
        Response.ResponseBuilder builder = body instanceof Response.ResponseBuilder ? (Response.ResponseBuilder)body : ResponseFactory.ok(body);
        return builder.build();
    }

    protected static interface RepositoryCallback {
        public Object doWithRepository(Repository var1, RefService var2);
    }
}

