/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityPage;
import com.atlassian.bitbucket.pull.PullRequestDeclineRequest;
import com.atlassian.bitbucket.pull.PullRequestDirection;
import com.atlassian.bitbucket.pull.PullRequestEntityType;
import com.atlassian.bitbucket.pull.PullRequestMergeRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.pull.PullRequestOrder;
import com.atlassian.bitbucket.pull.PullRequestParticipantRequest;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.pull.PullRequestUpdateRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.pull.RestPullRequest;
import com.atlassian.bitbucket.rest.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.rest.pull.RestPullRequestActivityPage;
import com.atlassian.bitbucket.rest.pull.RestPullRequestDeclineRequest;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeRequest;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeability;
import com.atlassian.bitbucket.rest.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.pull.RestPullRequestRef;
import com.atlassian.bitbucket.rest.pull.RestPullRequestReopenRequest;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.annotations.OptionalBody;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.google.common.collect.ImmutableList;
import com.sun.jersey.core.provider.EntityHolder;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestResource
extends AbstractPullRequestResource {
    private static final int MAX_PARTICIPANTS = 10;
    private static final String USERNAME = "username.";
    private static final String ROLE = "role.";
    private static final String APPROVED = "approved.";
    private final RepositoryService repositoryService;

    public PullRequestResource(I18nService i18nService, PullRequestService pullRequestService, RepositoryService repositoryService) {
        super(i18nService, pullRequestService);
        this.repositoryService = repositoryService;
    }

    @POST
    @Path(value="{pullRequestId}/decline")
    public Response decline(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @OptionalBody EntityHolder<RestPullRequestDeclineRequest> bodyHolder) {
        String comment = null;
        if (bodyHolder.hasEntity()) {
            RestPullRequestDeclineRequest declineRequest = (RestPullRequestDeclineRequest)bodyHolder.getEntity();
            comment = declineRequest.getComment();
            if (declineRequest.hasVersion()) {
                version = declineRequest.getVersion();
            }
        }
        PullRequest declined = this.pullRequestService.decline(new PullRequestDeclineRequest.Builder(repository.getId(), pullRequestId, version).comment(comment).build());
        return ResponseFactory.ok(new RestPullRequest(declined)).build();
    }

    @POST
    public Response create(@Context Repository to, @Context UriInfo uriInfo, RestPullRequest pullRequest) {
        Repository from;
        RestRepository fromRefRepository;
        String title = this.ensureHasProperty("title", pullRequest.getTitle());
        RestPullRequestRef fromRef = this.ensureHasProperty("fromRef", pullRequest.getFromRef());
        String fromBranchId = this.ensureHasProperty("fromRef.id", fromRef.getId());
        RestPullRequestRef toRef = this.ensureHasProperty("toRef", pullRequest.getToRef());
        String toBranchId = this.ensureHasProperty("toRef.id", toRef.getId());
        this.ensurePropertyNotSupplied("author", pullRequest.hasAuthor());
        this.ensurePropertyNotSupplied("participants", pullRequest.hasParticipants());
        Collection<RestPullRequestParticipant> reviewers = this.validateReviewers(pullRequest);
        RestRepository toRefRepository = toRef.getRepository();
        if (toRefRepository != null) {
            RestProject toProject = this.ensureHasProperty("toRef.repository.project", toRefRepository.getProject());
            String projectKey = this.ensureHasProperty("toRef.repository.project.key", toProject.getKey());
            String repositorySlug = this.ensureHasProperty("toRef.repository.slug", toRefRepository.getSlug());
            if (!projectKey.equalsIgnoreCase(to.getProject().getKey()) || !repositorySlug.equalsIgnoreCase(to.getSlug())) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.wrongurl", new Object[]{projectKey, repositorySlug, to.getProject().getKey(), to.getSlug()}));
            }
        }
        if ((fromRefRepository = fromRef.getRepository()) == null || fromRefRepository.isEmpty()) {
            from = to;
        } else {
            String repositorySlug;
            RestProject fromProject = this.ensureHasProperty("fromRef.repository.project", fromRefRepository.getProject());
            String projectKey = this.ensureHasProperty("fromRef.repository.project.key", fromProject.getKey());
            from = this.repositoryService.getBySlug(projectKey, repositorySlug = this.ensureHasProperty("fromRef.repository.slug", fromRefRepository.getSlug()));
            if (from == null) {
                throw this.noSuchRepoException(projectKey, repositorySlug);
            }
        }
        Set<String> reviewerNames = this.extractParticipantUsernames(reviewers);
        PullRequest created = this.pullRequestService.create(title, pullRequest.getDescription(), reviewerNames, from, fromBranchId, to, toBranchId);
        return ResponseFactory.created(uriInfo.getRequestUriBuilder().path(String.valueOf(created.getId())).build(new Object[0])).entity((Object)new RestPullRequest(created)).build();
    }

    @GET
    @Path(value="{pullRequestId}/activities")
    public Response getActivities(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="fromId") Long fromId, @QueryParam(value="fromType") String fromType, @Context PageRequest pageRequest) {
        if (fromId == null) {
            Page page = this.pullRequestService.getActivities(repository.getId(), pullRequestId, pageRequest);
            return ResponseFactory.ok(new RestPage<RestPullRequestActivity>(page, RestPullRequestActivity.REST_TRANSFORM)).build();
        }
        PullRequestActivityPage page = this.pullRequestService.getActivitiesStartingAt(repository.getId(), pullRequestId, this.toEntityType(fromType), fromId.longValue(), pageRequest);
        return ResponseFactory.ok(new RestPullRequestActivityPage((PullRequestActivityPage<? extends PullRequestActivity>)page, RestPullRequestActivity.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="{pullRequestId}")
    public Response get(@Context PullRequest pullRequest) {
        return ResponseFactory.ok(new RestPullRequest(pullRequest)).build();
    }

    @GET
    public Response getPage(@Context UriInfo uriInfo, @Context Repository repository, @QueryParam(value="direction") @DefaultValue(value="incoming") String direction, @QueryParam(value="at") String at, @QueryParam(value="state") String state, @QueryParam(value="order") String order, @QueryParam(value="withAttributes") @DefaultValue(value="true") Boolean withAttributes, @QueryParam(value="withProperties") @DefaultValue(value="true") Boolean withProperties, @Context PageRequest pageRequest) {
        PullRequestDirection prDirection = this.toDirection(direction);
        Iterable<PullRequestParticipantRequest> prParticipants = this.toParticipantSearchRequests((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        PullRequestState prState = this.toPullRequestState(state);
        PullRequestOrder resultOrder = PullRequestOrder.fromString((String)order, (PullRequestOrder)PullRequestOrder.getDefaultOrder());
        Page pullRequestPage = this.pullRequestService.search(new PullRequestSearchRequest.Builder().repositoryAndBranch(prDirection, Integer.valueOf(repository.getId()), at).state(prState).order(resultOrder).participants(prParticipants).withProperties(withProperties.booleanValue()).build(), pageRequest);
        return ResponseFactory.ok(new RestPage<RestPullRequest>(pullRequestPage, RestPullRequest.REST_TRANSFORM)).build();
    }

    @GET
    @Path(value="{pullRequestId}/merge")
    public Response canMerge(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId) {
        PullRequestMergeability mergeability = this.pullRequestService.canMerge(repository.getId(), pullRequestId);
        return ResponseFactory.ok(new RestPullRequestMergeability(mergeability)).build();
    }

    @POST
    @Path(value="{pullRequestId}/merge")
    public Response merge(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @OptionalBody EntityHolder<RestPullRequestMergeRequest> bodyHolder) {
        RestPullRequestMergeRequest mergeRequest = (RestPullRequestMergeRequest)bodyHolder.getEntity();
        if (mergeRequest != null && mergeRequest.hasVersion()) {
            version = mergeRequest.getVersion();
        }
        PullRequestMergeRequest.Builder builder = new PullRequestMergeRequest.Builder(repository.getId(), pullRequestId, version);
        if (mergeRequest != null) {
            builder.context(mergeRequest.getContext()).message(mergeRequest.getMessage());
        }
        return ResponseFactory.ok(new RestPullRequest(this.pullRequestService.merge(builder.build()))).build();
    }

    @POST
    @Path(value="{pullRequestId}/reopen")
    public Response reopen(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="version") @DefaultValue(value="-1") int version, @OptionalBody EntityHolder<RestPullRequestReopenRequest> bodyHolder) {
        RestPullRequestReopenRequest reopenRequest;
        if (bodyHolder.hasEntity() && (reopenRequest = (RestPullRequestReopenRequest)bodyHolder.getEntity()).hasVersion()) {
            version = reopenRequest.getVersion();
        }
        PullRequest pullRequest = this.pullRequestService.reopen(repository.getId(), pullRequestId, version);
        return ResponseFactory.ok(new RestPullRequest(pullRequest)).build();
    }

    @PUT
    @Path(value="{pullRequestId}")
    public Response update(@Context PullRequest pullRequest, RestPullRequest restPullRequest) {
        this.ensurePropertySupplied("version", restPullRequest.hasVersion());
        this.ensurePropertyNotSupplied("author", restPullRequest.hasAuthor());
        this.ensurePropertyNotSupplied("participants", restPullRequest.hasParticipants());
        Collection<RestPullRequestParticipant> reviewers = this.validateReviewers(restPullRequest);
        if (restPullRequest.getToRef() != null && StringUtils.isBlank((CharSequence)restPullRequest.getToRef().getId())) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.update.toref.blank", new Object[0]));
        }
        if (restPullRequest.hasTitle() || restPullRequest.hasDescription() || restPullRequest.hasReviewers() || restPullRequest.getToRef() != null) {
            String newDescription = restPullRequest.hasDescription() ? StringUtils.trimToNull((String)restPullRequest.getDescription()) : pullRequest.getDescription();
            PullRequestUpdateRequest.Builder builder = new PullRequestUpdateRequest.Builder(pullRequest, restPullRequest.getVersion()).title((String)StringUtils.defaultIfBlank((CharSequence)restPullRequest.getTitle(), (CharSequence)pullRequest.getTitle())).description(newDescription).reviewers(this.extractParticipantUsernames(reviewers)).toBranchId(restPullRequest.getToRef() != null ? restPullRequest.getToRef().getId() : null);
            return ResponseFactory.ok().entity((Object)new RestPullRequest(this.pullRequestService.update(builder.build()))).build();
        }
        throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.invalidupdateproperties", new Object[0]));
    }

    private Set<String> extractParticipantUsernames(Collection<RestPullRequestParticipant> participants) {
        return participants.stream().map(participant -> participant.getUser().getName()).collect(Collectors.toSet());
    }

    private PullRequestEntityType toEntityType(String entityType) {
        try {
            return StringUtils.isEmpty((CharSequence)entityType) ? PullRequestEntityType.ACTIVITY : PullRequestEntityType.valueOf((String)entityType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.activity.entity.invalid", new Object[]{this.toLowercaseNames((Enum[])PullRequestEntityType.values())}));
        }
    }

    private PullRequestState toPullRequestState(String state) {
        try {
            if (StringUtils.isEmpty((CharSequence)state)) {
                return PullRequestState.OPEN;
            }
            if (state.equalsIgnoreCase("all")) {
                return null;
            }
            return PullRequestState.valueOf((String)state.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.state.invalid", new Object[]{this.toLowercaseNames((Enum[])PullRequestState.values())}));
        }
    }

    private Iterable<PullRequestParticipantRequest> toParticipantSearchRequests(@Nonnull MultivaluedMap<String, String> parameters) {
        ImmutableList.Builder participants = ImmutableList.builder();
        for (int i = 1; i <= 10 && parameters.containsKey((Object)(USERNAME + i)); ++i) {
            PullRequestRole role;
            try {
                role = parameters.containsKey((Object)(ROLE + i)) ? PullRequestRole.valueOf((String)((String)parameters.getFirst((Object)(ROLE + i)))) : null;
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.pullrequests.invalidrole", new Object[]{parameters.getFirst((Object)(ROLE + i)), parameters.getFirst((Object)(USERNAME + i))}));
            }
            participants.add((Object)new PullRequestParticipantRequest.Builder((String)parameters.getFirst((Object)(USERNAME + i))).approved(parameters.containsKey((Object)(APPROVED + i)) ? Boolean.valueOf((String)parameters.getFirst((Object)(APPROVED + i))) : null).role(role).build());
        }
        return participants.build();
    }

    private Collection<RestPullRequestParticipant> validateReviewers(RestPullRequest restPullRequest) {
        Set<RestPullRequestParticipant> reviewers = restPullRequest.getReviewers();
        if (!reviewers.isEmpty()) {
            int i = 0;
            for (RestPullRequestParticipant participant : reviewers) {
                this.ensureHasProperty("reviewers[" + i + "].user", participant.getUser());
                this.ensureHasProperty("reviewers[" + i + "].user.name", participant.getUser().getName());
                ++i;
            }
        }
        return reviewers;
    }
}

