/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.pull.RestPullRequestParticipant;
import com.atlassian.bitbucket.rest.user.RestApplicationUser;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AuthorisationException;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.google.common.base.Joiner;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/participants")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestParticipantResource
extends AbstractPullRequestResource {
    private final AuthenticationContext authenticationContext;

    public PullRequestParticipantResource(I18nService i18nService, PullRequestService pullRequestService, AuthenticationContext authenticationContext) {
        super(i18nService, pullRequestService);
        this.authenticationContext = authenticationContext;
    }

    @GET
    public Response listParticipants(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @Context PageRequest pageRequest) {
        Page page = this.pullRequestService.getParticipants(repository.getId(), pullRequestId, pageRequest);
        return ResponseFactory.ok(new RestPage<RestPullRequestParticipant>(page, RestPullRequestParticipant::new)).build();
    }

    @POST
    public Response assignParticipantRole(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, RestPullRequestParticipant participant) {
        PullRequestRole role = this.ensureHasProperty("role", participant.getRole());
        RestApplicationUser user = this.ensureHasProperty("user", participant.getUser());
        String userName = this.ensureHasProperty("user.name", user.getName());
        PullRequestParticipant created = this.pullRequestService.assignRole(repository.getId(), pullRequestId, userName, role);
        return ResponseFactory.ok(new RestPullRequestParticipant(created)).build();
    }

    @DELETE
    @Deprecated
    public Response unassignParticipantRole(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @QueryParam(value="username") String username) {
        this.pullRequestService.unassignRole(repository.getId(), pullRequestId, this.ensureHasProperty("username", username));
        return ResponseFactory.noContent().build();
    }

    @DELETE
    @Path(value="{userSlug}")
    public Response unassignParticipantRole(@Context Repository repository, @Context ApplicationUser user, @PathParam(value="pullRequestId") long pullRequestId) {
        this.pullRequestService.removeReviewer(repository.getId(), pullRequestId, user.getName());
        return ResponseFactory.noContent().build();
    }

    @PUT
    @Path(value="{userSlug}")
    public Response updateStatus(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId, @PathParam(value="userSlug") String userSlug, RestPullRequestParticipant participant) {
        this.ensureIsValidUser(userSlug);
        return ResponseFactory.ok(new RestPullRequestParticipant(this.pullRequestService.setReviewerStatus(repository.getId(), pullRequestId, this.getStatus(participant)))).build();
    }

    private void ensureIsValidUser(String userSlug) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null || currentUser.getSlug().equals(userSlug)) {
            return;
        }
        throw new AuthorisationException(this.i18nService.getMessage("bitbucket.service.pullrequest.update.permissions.wronguser", new Object[0]));
    }

    private PullRequestParticipantStatus getStatus(RestPullRequestParticipant participant) {
        try {
            return participant.getStatus();
        }
        catch (IllegalArgumentException ignored) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.service.pullrequest.update.permissions.invalidstatus", new Object[]{Joiner.on((char)',').join((Object[])PullRequestParticipantStatus.values())}));
        }
    }
}

