/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.project;

import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectCreateRequest;
import com.atlassian.bitbucket.project.ProjectSearchRequest;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.project.ProjectUpdateRequest;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.multipart.FilePart;
import com.atlassian.plugins.rest.common.multipart.MultipartConfigClass;
import com.atlassian.plugins.rest.common.multipart.MultipartFormParam;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.avatar.AvatarMultipartConfig;
import com.atlassian.stash.internal.rest.avatar.FilePartAvatarSupplier;
import com.atlassian.stash.internal.rest.util.RestPermissionUtils;
import com.google.common.base.MoreObjects;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ProjectResource
extends RestResource {
    private static final String AVATAR_PATH = "{projectKey}/avatar.png";
    private final ProjectService projectService;

    public ProjectResource(ProjectService projectService, I18nService i18nService) {
        super(i18nService);
        this.projectService = projectService;
    }

    @POST
    public Response createProject(@Context UriInfo uriInfo, RestProject projectParam) {
        String projectKey = projectParam.getKey();
        if (projectKey == null) {
            String message = this.i18nService.getMessage("bitbucket.rest.project.noprojectkey", new Object[0]);
            throw new BadRequestException(message);
        }
        String name = projectParam.getName();
        if (name == null) {
            name = projectKey;
        }
        Project project = this.projectService.create(((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)((ProjectCreateRequest.Builder)new ProjectCreateRequest.Builder().key(projectKey)).name(name)).description(projectParam.getDescription())).avatarUri(projectParam.getAvatar()).publiclyAccessible(projectParam.isPublic())).build());
        URI projectURI = uriInfo.getRequestUriBuilder().path(project.getKey()).build(new Object[0]);
        return ResponseFactory.created(projectURI).entity((Object)RestProject.REST_TRANSFORM.apply(project)).build();
    }

    @DELETE
    @Path(value="{projectKey}")
    public Response deleteProject(@Context Project project) {
        if (!this.projectService.delete(project)) {
            throw this.noSuchProjectException(project.getKey());
        }
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{projectKey}")
    public Response getProject(@Context Project project) {
        return ResponseFactory.ok(RestProject.REST_TRANSFORM.apply(project)).build();
    }

    @GET
    @Path(value="{projectKey}/avatar.png")
    @Produces(value={"image/png"})
    public Response getProjectAvatar(@Context ContainerRequest request, @Context Project project, @QueryParam(value="s") @DefaultValue(value="0") int size) {
        return RestUtils.processAvatarResponse(request, CachePolicies.noCache(), this.projectService.getAvatar(project.getId(), size));
    }

    @GET
    public Response getProjects(@QueryParam(value="name") String name, @QueryParam(value="permission") String permission, @Context PageRequest pageRequest) {
        ProjectSearchRequest.Builder builder = new ProjectSearchRequest.Builder().name(name).permission(RestPermissionUtils.parsePermission(this.i18nService, permission, Project.class));
        Page page = this.projectService.search(builder.build(), pageRequest);
        return ResponseFactory.ok(new RestPage<RestProject>(page, RestProject.REST_TRANSFORM)).build();
    }

    @PUT
    @Path(value="{projectKey}")
    public Response updateProject(@Context Project project, RestProject projectParam, @Context UriInfo uriInfo) {
        ProjectUpdateRequest.Builder builder = (ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)((ProjectUpdateRequest.Builder)new ProjectUpdateRequest.Builder(project).key((String)MoreObjects.firstNonNull((Object)projectParam.getKey(), (Object)project.getKey()))).name((String)MoreObjects.firstNonNull((Object)projectParam.getName(), (Object)project.getName()))).description(projectParam.getDescription() != null ? projectParam.getDescription() : project.getDescription());
        if (projectParam.hasPublic()) {
            builder.publiclyAccessible(projectParam.isPublic());
        }
        Project updatedProject = this.projectService.update(builder.build());
        if (projectParam.hasAvatar()) {
            this.projectService.updateAvatar(project.getId(), projectParam.getAvatar());
        }
        if (updatedProject.getKey().equals(project.getKey())) {
            return ResponseFactory.ok(RestProject.REST_TRANSFORM.apply(updatedProject)).build();
        }
        String requestPath = uriInfo.getRequestUri().getPath();
        int index = requestPath.toLowerCase().lastIndexOf(project.getKey().toLowerCase());
        String newPath = requestPath.substring(0, index) + updatedProject.getKey();
        return ResponseFactory.created(uriInfo.getRequestUriBuilder().replacePath(newPath).build(new Object[0])).entity((Object)RestProject.REST_TRANSFORM.apply(updatedProject)).build();
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @MultipartConfigClass(value=AvatarMultipartConfig.class)
    @Path(value="{projectKey}/avatar.png")
    public Response uploadAvatar(@Context Project project, @Context UriInfo uriInfo, @MultipartFormParam(value="avatar") FilePart file) {
        this.projectService.updateAvatar(project.getId(), (AvatarSupplier)new FilePartAvatarSupplier(file));
        return Response.created((URI)uriInfo.getRequestUri()).build();
    }
}

