/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.license;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.license.RestBitbucketLicense;
import com.atlassian.bitbucket.rest.license.RestLicenseStatus;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.extras.api.bitbucket.BitbucketServerLicense;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="admin/license")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class LicenseResource {
    private final I18nService i18nService;
    private final LicenseService licenseService;
    private final ApplicationPropertiesService propertiesService;
    private final PermissionValidationService validationService;

    public LicenseResource(I18nService i18nService, LicenseService licenseService, ApplicationPropertiesService propertiesService, PermissionValidationService validationService) {
        this.i18nService = i18nService;
        this.licenseService = licenseService;
        this.propertiesService = propertiesService;
        this.validationService = validationService;
    }

    @GET
    public Response get() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        return this.getAndTransform();
    }

    @POST
    public Response update(RestBitbucketLicense restLicense) {
        String license = restLicense.getLicense();
        if (StringUtils.isBlank((CharSequence)license)) {
            throw new BadRequestException(this.i18nService.getMessage("bitbucket.rest.license.nolicenseprovided", new Object[0]));
        }
        try {
            this.licenseService.set(license);
        }
        catch (InvalidLicenseException e) {
            return ResponseFactory.status(Response.Status.CONFLICT).entity((Object)new RestErrors((ServiceException)e)).build();
        }
        return this.getAndTransform();
    }

    private Response getAndTransform() {
        BitbucketServerLicense license = this.licenseService.get();
        if (license == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.rest.license.nolicenseset", new Object[]{Product.NAME}));
        }
        RestLicenseStatus status = new RestLicenseStatus(this.propertiesService.getServerId(), this.licenseService.getLicensedUsersCount(), this.licenseService.getOverLimitMessage(), this.licenseService.getValidityMessage());
        return ResponseFactory.ok(new RestBitbucketLicense(license, this.licenseService.getAsString(), status)).build();
    }
}

