/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.rest.annotation.SecondaryRepository;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.reflect.Type;
import javax.ws.rs.core.MultivaluedMap;

public class SecondaryRepositoryInjectableProvider
implements InjectableProvider<SecondaryRepository, Type> {
    static final String PARAM_REPOSITORY_ID = "secondaryRepositoryId";
    static final String PARAM_PROJECT_KEY = "secondaryProjectKey";
    static final String PARAM_REPOSITORY_SLUG = "secondaryRepositorySlug";
    private final I18nService i18nService;
    private final ProjectService projectService;
    private final RepositoryService repositoryService;

    public SecondaryRepositoryInjectableProvider(I18nService i18nService, ProjectService projectService, RepositoryService repositoryService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
        this.repositoryService = repositoryService;
    }

    public Injectable getInjectable(ComponentContext context, SecondaryRepository annotation, Type type) {
        return Repository.class.equals((Object)type) ? new SecondaryRepositoryInjectable() : null;
    }

    public ComponentScope getScope() {
        return ComponentScope.Singleton;
    }

    private class SecondaryRepositoryInjectable
    extends AbstractResourceInjectable<Repository> {
        private SecondaryRepositoryInjectable() {
        }

        @Override
        protected Repository doGetValue(HttpContext httpContext) {
            MultivaluedMap queryParameters = httpContext.getRequest().getQueryParameters();
            String id = (String)queryParameters.getFirst((Object)SecondaryRepositoryInjectableProvider.PARAM_REPOSITORY_ID);
            if (id != null) {
                Repository repository = SecondaryRepositoryInjectableProvider.this.repositoryService.getById(Integer.parseInt(id));
                if (repository == null) {
                    throw new NoSuchRepositoryException(SecondaryRepositoryInjectableProvider.this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyid", new Object[]{id}), (Project)null);
                }
                return repository;
            }
            String pathProjectKey = HttpContextUtils.requireSinglePathSegmentValue("projectKey", httpContext, Repository.class);
            String pathRepositorySlug = HttpContextUtils.requireSinglePathSegmentValue("repositorySlug", httpContext, Repository.class);
            String projectKey = (String)queryParameters.getFirst((Object)SecondaryRepositoryInjectableProvider.PARAM_PROJECT_KEY);
            String repositorySlug = (String)queryParameters.getFirst((Object)SecondaryRepositoryInjectableProvider.PARAM_REPOSITORY_SLUG);
            if (projectKey == null) {
                projectKey = pathProjectKey;
            }
            if (repositorySlug == null) {
                repositorySlug = pathRepositorySlug;
            }
            if (projectKey.equals(pathProjectKey) && repositorySlug.equals(pathRepositorySlug)) {
                return null;
            }
            Repository repository = SecondaryRepositoryInjectableProvider.this.repositoryService.getBySlug(projectKey, repositorySlug);
            if (repository == null) {
                Project project = SecondaryRepositoryInjectableProvider.this.projectService.getByKey(projectKey);
                if (project == null) {
                    throw new NoSuchProjectException(SecondaryRepositoryInjectableProvider.this.i18nService.createKeyedMessage("bitbucket.rest.nosuchproject.secondarybykey", new Object[]{projectKey}));
                }
                KeyedMessage message = SecondaryRepositoryInjectableProvider.this.i18nService.createKeyedMessage("bitbucket.rest.nosuchrepo.secondarybyslug", new Object[]{projectKey, repositorySlug});
                throw new NoSuchRepositoryException(message, project);
            }
            return repository;
        }
    }
}

