/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.inject.RepositoryInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import javax.annotation.Nonnull;

public class PullRequestInjectable
extends AbstractResourceInjectable<PullRequest> {
    private final I18nService i18nService;
    private final PullRequestService pullRequestService;
    private final RepositoryInjectable repositoryInjectable;

    public PullRequestInjectable(I18nService i18nService, PullRequestService pullRequestService, RepositoryInjectable repositoryInjectable) {
        this.i18nService = i18nService;
        this.pullRequestService = pullRequestService;
        this.repositoryInjectable = repositoryInjectable;
    }

    @Override
    @Nonnull
    public PullRequest doGetValue(HttpContext httpContext) {
        Repository repository = (Repository)this.repositoryInjectable.getValue(httpContext);
        String pullRequestId = HttpContextUtils.requireSinglePathSegmentValue("pullRequestId", httpContext, PullRequest.class);
        PullRequest pullRequest = this.pullRequestService.getById(repository.getId(), Long.parseLong(pullRequestId));
        if (pullRequest == null) {
            throw new NoSuchPullRequestException(this.i18nService.createKeyedMessage("bitbucket.rest.nosuchpullrequest", new Object[]{pullRequestId, repository.getProject().getKey(), repository.getSlug()}));
        }
        return pullRequest;
    }
}

