/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.exception;

import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.validation.FormErrors;
import com.atlassian.bitbucket.validation.FormValidationException;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;

class ValidationExceptionMapper
implements ExceptionMapper<FormValidationException> {
    ValidationExceptionMapper() {
    }

    public Response toResponse(FormValidationException exception) {
        RestErrors.Builder errors = new RestErrors.Builder();
        FormErrors formErrors = exception.getErrors();
        for (String string : formErrors.getFormErrors()) {
            errors.add(new RestErrorMessage(string));
        }
        for (Map.Entry entry : formErrors.getFieldErrors().entrySet()) {
            for (String message : (Collection)entry.getValue()) {
                errors.add(new RestErrorMessage((String)entry.getKey(), message));
            }
        }
        return ResponseFactory.status(Response.Status.BAD_REQUEST).entity((Object)errors.build()).type("application/json;charset=UTF-8").build();
    }
}

