/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.cluster;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.cluster.RestClusterInformation;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="admin/cluster")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class ClusterResource {
    private final ClusterService clusterService;
    private final PermissionValidationService validationService;

    public ClusterResource(ClusterService clusterService, PermissionValidationService validationService) {
        this.clusterService = clusterService;
        this.validationService = validationService;
    }

    @GET
    public Response getInformation() {
        this.validationService.validateForGlobal(Permission.SYS_ADMIN);
        return ResponseFactory.ok(new RestClusterInformation(this.clusterService.getInformation())).build();
    }
}

