/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.auth;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationFailureHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationModeSupplier;
import java.io.IOException;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RestAuthenticationFailureHandler
implements HttpAuthenticationFailureHandler {
    public static final String REST_PATH_PREFIX = "/rest/";
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final JsonRenderer jsonRenderer;
    private final ApplicationModeSupplier modeSupplier;

    public RestAuthenticationFailureHandler(ApplicationModeSupplier modeSupplier, I18nService i18nService, NavBuilder navBuilder, JsonRenderer jsonRenderer) {
        this.modeSupplier = modeSupplier;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.jsonRenderer = jsonRenderer;
    }

    public boolean onAuthenticationFailure(@Nonnull HttpAuthenticationFailureContext context) throws IOException {
        String message;
        HttpServletRequest request = context.getRequest();
        if (!request.getServletPath().startsWith(REST_PATH_PREFIX)) {
            return false;
        }
        switch (context.getAuthenticationState()) {
            case CAPTCHA_REQUIRED: {
                if (this.modeSupplier.getMode() == ApplicationMode.MIRROR) {
                    message = this.i18nService.getMessage("bitbucket.rest.auth.captcha.required.upstream", new Object[]{Product.NAME});
                    break;
                }
                message = this.i18nService.getMessage("bitbucket.rest.auth.captcha.required", new Object[]{Product.NAME, this.navBuilder.buildAbsolute()});
                break;
            }
            case UNLICENSED: {
                message = this.i18nService.getMessage("bitbucket.rest.auth.unlicensed", new Object[]{Product.NAME});
                break;
            }
            default: {
                message = this.i18nService.getMessage("bitbucket.rest.auth.failed", new Object[0]);
            }
        }
        HttpServletResponse response = context.getResponse();
        response.setStatus(401);
        if ("basic".equals(context.getMethod())) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"Atlassian Bitbucket\"");
        }
        response.setContentType("application/json;charset=UTF-8");
        RestErrors errors = new RestErrors(new RestErrorMessage(null, message, context.getAuthenticationException().getClass().getName()));
        response.getWriter().write(this.jsonRenderer.render((Object)errors, Collections.emptyMap()));
        return true;
    }
}

