/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.user;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.user.RecentlyAccessedRepositoriesService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.util.RestPermissionUtils;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="profile/recent/repos")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class RecentlyAccessedRepositoriesResource
extends RestResource {
    private final RecentlyAccessedRepositoriesService recentRepositoriesService;

    public RecentlyAccessedRepositoriesResource(I18nService i18nService, RecentlyAccessedRepositoriesService recentRepositoriesService) {
        super(i18nService);
        this.recentRepositoriesService = recentRepositoriesService;
    }

    @GET
    public Response getRepositoriesRecentlyAccessed(@Context ContainerRequest request, @QueryParam(value="permission") String permission) {
        PageRequest pageRequest = RestUtils.makePageRequest((HttpRequestContext)request, 15);
        Permission stashPermission = RestPermissionUtils.parsePermission(this.i18nService, permission, Repository.class, Permission.REPO_READ, "permission");
        Page page = this.recentRepositoriesService.findByCurrentUser(stashPermission, pageRequest);
        return ResponseFactory.ok(new RestPage<RestRepository>(page, RestRepository.REST_TRANSFORM)).build();
    }
}

