/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHookService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="hooks")
@Singleton
public class RepositoryHookAvatarResource
extends RestResource {
    private final RepositoryHookService repositoryHookService;

    public RepositoryHookAvatarResource(I18nService i18nService, RepositoryHookService repositoryHookService) {
        super(i18nService);
        this.repositoryHookService = repositoryHookService;
    }

    @GET
    @Path(value="{hookKey}/avatar")
    public Response getAvatar(@Context ContainerRequest request, @PathParam(value="hookKey") String hookKey, @QueryParam(value="version") String version) {
        boolean hasVersion = StringUtils.isNotEmpty((String)version) && !version.endsWith("-SNAPSHOT");
        CacheControl cacheControl = hasVersion ? CachePolicies.cacheForAMonth() : CachePolicies.noCache();
        return RestUtils.processAvatarResponse(request, cacheControl, this.repositoryHookService.getAvatar(hookKey));
    }
}

