/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.renderer;

import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.enrich.MarkupEnricher;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.stash.internal.rest.renderer.AggregateBuilder;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseSurrogateJsonRenderer
implements JsonRenderer {
    private static final Logger log = LoggerFactory.getLogger(BaseSurrogateJsonRenderer.class);
    protected final AggregateBuilder aggregateBuilder;
    protected final AvatarEnricher avatarEnricher;
    protected final MarkupEnricher markupEnricher;
    protected final LinkEnricher linkEnricher;
    protected final JsonFactory jsonFactory;
    protected final RequestManager requestManager;

    public BaseSurrogateJsonRenderer(RequestManager requestManager, AggregateBuilder aggregateBuilder, AvatarEnricher avatarEnricher, MarkupEnricher markupEnricher, LinkEnricher linkEnricher) {
        this.requestManager = requestManager;
        this.aggregateBuilder = aggregateBuilder;
        this.avatarEnricher = avatarEnricher;
        this.markupEnricher = markupEnricher;
        this.linkEnricher = linkEnricher;
        this.jsonFactory = new ObjectMapper().getJsonFactory();
    }

    @Nullable
    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        Object surrogate = this.aggregateBuilder.buildFor(object);
        if (surrogate == null) {
            return null;
        }
        this.enrich(options, surrogate);
        try {
            return this.render(options, surrogate);
        }
        catch (IOException e) {
            log.error(String.format("Failed to render JSON for object of type %s with surrogate of type %s", object.getClass().getName(), surrogate.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    private void enrich(Map<String, Object> options, Object surrogate) {
        this.linkEnricher.enrich(surrogate);
        this.avatarEnricher.enrich(surrogate, RestUtils.makeAvatarRequest(this.requestManager, options));
        if (options.containsKey("markup")) {
            this.markupEnricher.enrich(surrogate);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private String render(@Nonnull Map<String, Object> options, @Nonnull Object surrogate) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Boolean doEndTagEscaping(Map<String, Object> options) {
        Object noEscape = options.get("noEndTagEscape");
        return noEscape instanceof Boolean ? !((Boolean)noEscape).booleanValue() : !(noEscape instanceof String) || Boolean.valueOf((String)noEscape) == false;
    }
}

