/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.render;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.markup.MarkupService;
import com.atlassian.bitbucket.markup.RenderContext;
import com.atlassian.bitbucket.markup.RenderException;
import com.atlassian.bitbucket.markup.UrlMode;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.markup.RestMarkup;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import java.util.Locale;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="markup")
@Produces(value={"application/json;charset=UTF-8"})
@AnonymousAllowed
@Singleton
public class MarkupResource
extends RestResource {
    private final MarkupService markupService;
    private final PermissionValidationService permissionValidationService;

    public MarkupResource(I18nService i18nService, MarkupService markupService, PermissionValidationService permissionValidationService) {
        super(i18nService);
        this.markupService = markupService;
        this.permissionValidationService = permissionValidationService;
    }

    @POST
    @Path(value="preview")
    public Response preview(@QueryParam(value="urlMode") String urlModeAsString, @QueryParam(value="hardwrap") Boolean hardwrap, @QueryParam(value="htmlEscape") Boolean htmlEscape, String content) {
        this.permissionValidationService.validateAuthenticated();
        RenderContext.Builder contextBuilder = new RenderContext.Builder();
        if (urlModeAsString != null) {
            contextBuilder = contextBuilder.urlMode(UrlMode.valueOf((String)urlModeAsString.toUpperCase(Locale.US)));
        }
        if (hardwrap != null) {
            contextBuilder = contextBuilder.hardwrap(hardwrap.booleanValue());
        }
        if (htmlEscape != null) {
            contextBuilder = contextBuilder.htmlEscape(htmlEscape.booleanValue());
        }
        try {
            return ResponseFactory.ok(new RestMarkup(this.markupService.render(content, contextBuilder.build()))).build();
        }
        catch (RenderException e) {
            throw new BadRequestException(e.getLocalizedMessage());
        }
    }
}

