/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/watch")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestWatchResource
extends AbstractPullRequestResource {
    public PullRequestWatchResource(I18nService i18nService, PullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @POST
    public Response watch(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId) {
        this.pullRequestService.watch(repository.getId(), pullRequestId);
        return ResponseFactory.noContent().build();
    }

    @DELETE
    public Response unwatch(@Context Repository repository, @PathParam(value="pullRequestId") long pullRequestId) {
        this.pullRequestService.unwatch(repository.getId(), pullRequestId);
        return ResponseFactory.noContent().build();
    }
}

