/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.secretscanning;

import com.atlassian.bitbucket.dmz.secretscanning.DmzSecretScanningRule;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.Scopes;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RestSecretScanningRule
extends RestMapEntity {
    private static final String ID = "id";
    private static final String LINE_REGEX = "lineRegex";
    private static final String NAME = "name";
    private static final String PATH_REGEX = "pathRegex";
    private static final String SCOPE = "scope";

    public RestSecretScanningRule() {
    }

    public RestSecretScanningRule(Map<String, ?> values) {
        super(values);
    }

    public RestSecretScanningRule(long id, @Nonnull String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        this.put(ID, id);
        this.put(NAME, Objects.requireNonNull(name, NAME));
        this.putIfNotNull(LINE_REGEX, lineRegex);
        this.putIfNotNull(PATH_REGEX, pathRegex);
        this.put(SCOPE, new RestScope((Scope)Scopes.global()));
    }

    public RestSecretScanningRule(long id, @Nonnull String name, @Nullable String lineRegex, @Nullable String pathRegex, @Nonnull Scope scope) {
        this.put(ID, id);
        this.put(NAME, Objects.requireNonNull(name, NAME));
        this.putIfNotNull(LINE_REGEX, lineRegex);
        this.putIfNotNull(PATH_REGEX, pathRegex);
        this.put(SCOPE, new RestScope(Objects.requireNonNull(scope, SCOPE)));
    }

    public RestSecretScanningRule(DmzSecretScanningRule rule) {
        this(rule.getId(), rule.getName(), rule.getLineRegex().orElse(null), rule.getPathRegex().orElse(null), rule.getScope());
    }

    @Schema(description="The ID of the rule", example="7")
    public long getId() {
        return this.getLongProperty(ID);
    }

    @Schema(description="If present, regular expression for matching a secret on a code line", example="(BBDC-[a-zA-Z0-9+]{44})")
    @Nullable
    public String getLineRegex() {
        return this.getStringProperty(LINE_REGEX);
    }

    @Schema(description="Human readable name for the rule", example="Bitbucket DC HTTP access token")
    @Nonnull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(description="If present, regular expression matching file names", example="*.pem")
    @Nullable
    public String getPathRegex() {
        return this.getStringProperty(PATH_REGEX);
    }

    @Schema(description="The scope in which this rule was configured for.")
    @Nonnull
    public RestScope getScope() {
        return RestScope.valueOf((Object)this.get(SCOPE));
    }
}

