/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.ratelimit.UserRateLimitSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RestUserRateLimitSettings
extends RestMapEntity {
    public static final String SETTINGS = "settings";
    public static final String USER = "user";
    public static final String WHITELISTED = "whitelisted";

    public RestUserRateLimitSettings() {
    }

    public RestUserRateLimitSettings(@Nonnull UserRateLimitSettings userRateLimitSettings) {
        Objects.requireNonNull(userRateLimitSettings, "userRateLimitSettings");
        this.put(USER, new RestApplicationUser(userRateLimitSettings.getUser()));
        if (userRateLimitSettings.isWhitelisted()) {
            this.put(WHITELISTED, true);
        } else {
            this.put(SETTINGS, (Object)userRateLimitSettings.getSettings().map(RestTokenBucketSettings::new).get());
        }
    }

    private RestUserRateLimitSettings(Builder builder) {
        Preconditions.checkArgument((builder.whitelisted || builder.settings != null ? 1 : 0) != 0, (Object)"Either user is whitelisted or token bucket settings must be provided.");
        this.put(USER, builder.user);
        if (builder.whitelisted) {
            this.put(WHITELISTED, true);
        } else {
            this.put(SETTINGS, (Object)builder.settings);
        }
    }

    public RestTokenBucketSettings getSettings() {
        return RestTokenBucketSettings.valueOf(this.get(SETTINGS));
    }

    public RestApplicationUser getUser() {
        return RestApplicationUser.valueOf((Object)this.get(USER));
    }

    public boolean hasSettings() {
        return this.get(SETTINGS) != null;
    }

    public boolean isWhitelisted() {
        return this.getBoolProperty(WHITELISTED);
    }

    public static class Builder {
        private final RestApplicationUser user;
        private RestTokenBucketSettings settings;
        private boolean whitelisted;

        public Builder(@Nonnull ApplicationUser user) {
            this.user = Objects.requireNonNull(user, RestUserRateLimitSettings.USER) instanceof RestApplicationUser ? (RestApplicationUser)user : new RestApplicationUser(user);
        }

        public RestUserRateLimitSettings build() {
            return new RestUserRateLimitSettings(this);
        }

        public Builder whitelisted() {
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(RestTokenBucketSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withSettings(TokenBucketSettings settings) {
            this.settings = RestTokenBucketSettings.valueOf(settings);
            return this;
        }
    }
}

