/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;

@JsonSerialize
@JsonSurrogate(value=RescopeDetails.class)
public class RestRescopeDetails
extends RestMapEntity {
    private static final String COMMITS = "commits";
    private static final String TOTAL = "total";

    public RestRescopeDetails(RescopeDetails details) {
        this((List<RestCommit>)ImmutableList.copyOf((Collection)Lists.transform((List)details.getCommits(), RestCommit::new)), details.getTotal());
    }

    private RestRescopeDetails(List<RestCommit> commits, int total) {
        this.put(COMMITS, commits);
        this.put(TOTAL, total);
    }

    private RestRescopeDetails(RestCommit commit) {
        this((List<RestCommit>)ImmutableList.of((Object)commit), 1);
    }

    @ArraySchema(schema=@Schema(implementation=RestCommit.class))
    public List<RestCommit> getCommits() {
        return (List)this.get(COMMITS);
    }

    public int getTotal() {
        return this.getIntProperty(TOTAL);
    }
}

