/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.migration;

import com.atlassian.bitbucket.dmz.rest.v2.migration.RestRepositoriesExportRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonSerialize
public class RestExportRequest
extends RestMapEntity {
    public static final String EXPORT_LOCATION = "exportLocation";
    public static final String REPOSITORIES_REQUEST = "repositoriesRequest";

    public RestExportRequest() {
    }

    public RestExportRequest(String exportLocation, RestRepositoriesExportRequest repositoryRequest) {
        this.putIfNotNull(EXPORT_LOCATION, exportLocation);
        this.put(REPOSITORIES_REQUEST, (Object)repositoryRequest);
    }

    public RestExportRequest(Map value) {
        super(value);
    }

    @Nullable
    @Schema(example="example/sub/directory")
    public String getExportLocation() {
        return this.getStringProperty(EXPORT_LOCATION);
    }

    @NotNull(message="{bitbucket.rest.migration.repositoryrequest.required}")
    @Valid
    public @NotNull(message="{bitbucket.rest.migration.repositoryrequest.required}") @Valid RestRepositoriesExportRequest getRepositoriesRequest() {
        return RestRepositoriesExportRequest.valueOf(this.get(REPOSITORIES_REQUEST));
    }
}

