/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.hook.script;

import com.atlassian.bitbucket.hook.script.HookScript;
import com.atlassian.bitbucket.hook.script.HookScriptType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Optional;

@JsonSerialize
@JsonSurrogate(value=HookScript.class)
public class RestHookScript
extends RestMapEntity {
    private static final String CREATED_DATE = "createdDate";
    private static final String DESCRIPTION = "description";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String PLUGIN_KEY = "pluginKey";
    private static final String SIZE = "size";
    private static final String TYPE = "type";
    private static final String UPDATED_DATE = "updatedDate";
    private static final String VERSION = "version";

    public RestHookScript() {
    }

    public RestHookScript(HookScript script) {
        this.put(ID, script.getId());
        this.put(NAME, script.getName());
        this.put(PLUGIN_KEY, script.getPluginKey());
        this.put(SIZE, script.getSize());
        this.put(TYPE, script.getType());
        this.put(CREATED_DATE, script.getCreatedDate());
        this.put(UPDATED_DATE, script.getUpdatedDate());
        this.put(VERSION, script.getVersion());
        script.getDescription().ifPresent(description -> this.put(DESCRIPTION, description));
    }

    public Date getCreatedDate() {
        return (Date)this.get(CREATED_DATE);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.getStringProperty(DESCRIPTION));
    }

    public long getId() {
        return this.getLongProperty(ID);
    }

    public String getName() {
        return this.getStringProperty(NAME);
    }

    public String getPluginKey() {
        return this.getStringProperty(PLUGIN_KEY);
    }

    public HookScriptType getType() {
        return (HookScriptType)this.getEnumProperty(TYPE, HookScriptType.class);
    }

    public Date getUpdatedDate() {
        return (Date)this.get(UPDATED_DATE);
    }

    public int getVersion() {
        return this.getIntProperty(VERSION);
    }
}

