/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.deployment;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironment;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
@JsonSurrogate(value=DeploymentEnvironment.class)
public class RestDeploymentEnvironment
extends RestMapEntity {
    private static final String DISPLAY_NAME = "displayName";
    private static final String KEY = "key";
    private static final String TYPE = "type";
    private static final String URL = "url";

    public RestDeploymentEnvironment() {
    }

    public RestDeploymentEnvironment(@Nonnull DeploymentEnvironment environment) {
        this(environment.getDisplayName(), environment.getKey(), environment.getType().map(Enum::name).orElse(null), environment.getUrl().map(URI::toASCIIString).orElse(null));
    }

    RestDeploymentEnvironment(@Nonnull String displayName, @Nonnull String key, @Nullable String type, @Nullable String url) {
        this.put(DISPLAY_NAME, StringUtils.stripToNull((String)displayName));
        this.put(KEY, StringUtils.stripToNull((String)key));
        this.putIfNotNull(TYPE, StringUtils.stripToNull((String)type));
        this.putIfNotNull(URL, StringUtils.stripToNull((String)url));
    }

    private RestDeploymentEnvironment(Map<String, Object> values) {
        super(values);
    }

    @Nullable
    public static RestDeploymentEnvironment valueOf(@Nullable Object value) {
        if (value instanceof RestDeploymentEnvironment) {
            return (RestDeploymentEnvironment)((Object)value);
        }
        if (value instanceof Map) {
            return new RestDeploymentEnvironment((Map)value);
        }
        return null;
    }

    @Nonnull
    @NotBlank(message="{bitbucket.deployment.environment.name.required}")
    @Schema(example="US East Mirror")
    @Size(max=255, message="{bitbucket.deployment.environment.name.length.too.long}")
    public @NotBlank(message="{bitbucket.deployment.environment.name.required}") @Size(max=255, message="{bitbucket.deployment.environment.name.length.too.long}") String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Nonnull
    @NotBlank(message="{bitbucket.deployment.environment.key.required}")
    @Schema(example="us-east-mirror")
    @Size(max=255, message="{bitbucket.deployment.environment.key.length.too.long}")
    public @NotBlank(message="{bitbucket.deployment.environment.key.required}") @Size(max=255, message="{bitbucket.deployment.environment.key.length.too.long}") String getKey() {
        return this.getStringProperty(KEY);
    }

    @Nullable
    @Pattern(regexp="DEVELOPMENT|TESTING|STAGING|PRODUCTION", message="{bitbucket.deployment.environment.type.pattern}")
    @Schema(example="production")
    public @Pattern(regexp="DEVELOPMENT|TESTING|STAGING|PRODUCTION", message="{bitbucket.deployment.environment.type.pattern}") String getType() {
        return this.getStringProperty(TYPE);
    }

    @Nullable
    @Schema(example="https://foo-bar.production/us-east")
    @Size(max=1024, message="{bitbucket.deployment.environment.url.length.too.long}")
    public @Size(max=1024, message="{bitbucket.deployment.environment.url.length.too.long}") String getUrl() {
        return this.getStringProperty(URL);
    }
}

