/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.dashboard;

import com.atlassian.bitbucket.dashboard.PullRequestSuggestion;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestRefChange;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.repository.RestRepository;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.function.Function;

@JsonSurrogate(value=PullRequestSuggestion.class)
public class RestPullRequestSuggestion
extends RestMapEntity {
    public static final Function<PullRequestSuggestion, RestPullRequestSuggestion> REST_TRANSFORM = RestPullRequestSuggestion::new;
    private static final String CHANGE_TIME = "changeTime";
    private static final String FROM_REF = "fromRef";
    private static final String REF_CHANGE = "refChange";
    private static final String REPOSITORY = "repository";
    private static final String TO_REF = "toRef";

    public RestPullRequestSuggestion(PullRequestSuggestion suggestion) {
        this(suggestion.getChangeDate(), new RestRefChange(suggestion.getRefChange()), new RestRepository(suggestion.getRepository()), new RestMinimalRef(suggestion.getFromRef()), new RestMinimalRef(suggestion.getToRef()));
    }

    protected RestPullRequestSuggestion(Date changeTime, RestRefChange refChange, RestRepository repository, RestMinimalRef fromRef, RestMinimalRef toRef) {
        this.put(CHANGE_TIME, changeTime);
        this.put(REF_CHANGE, (Object)refChange);
        this.put(REPOSITORY, repository);
        this.put(FROM_REF, fromRef);
        this.put(TO_REF, toRef);
    }

    @Schema(example="1359075920")
    public long getChangeTme() {
        return this.getLongProperty(CHANGE_TIME);
    }

    public RestMinimalRef getFromRef() {
        return (RestMinimalRef)this.get(FROM_REF);
    }

    public RestRefChange getRefChange() {
        return (RestRefChange)((Object)this.get(REF_CHANGE));
    }

    public RestRepository getRepository() {
        return (RestRepository)this.get(REPOSITORY);
    }

    public RestMinimalRef getToRef() {
        return (RestMinimalRef)this.get(TO_REF);
    }
}

