/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.ratelimit;

import com.atlassian.bitbucket.dmz.ratelimit.TokenBucketSettings;
import com.atlassian.bitbucket.dmz.rest.v2.ratelimit.RestTokenBucketSettings;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import javax.annotation.Nonnull;

public class RestBulkUserRateLimitSettingsUpdateResponse
extends RestMapEntity {
    public static final String USERS = "users";

    public RestBulkUserRateLimitSettingsUpdateResponse() {
    }

    private RestBulkUserRateLimitSettingsUpdateResponse(Builder builder) {
        Preconditions.checkArgument((builder.whitelisted || builder.settings != null ? 1 : 0) != 0, (Object)"Either user is whitelisted or token bucket settings must be provided.");
        this.put(USERS, builder.users);
        if (builder.whitelisted) {
            this.put("whitelisted", true);
        } else {
            this.put("settings", (Object)builder.settings);
        }
    }

    public RestTokenBucketSettings getSettings() {
        return RestTokenBucketSettings.valueOf(this.get("settings"));
    }

    public Iterable<RestApplicationUser> getUsers() {
        Object users = this.get(USERS);
        if (users == null) {
            return ImmutableList.of();
        }
        return (Iterable)users;
    }

    public boolean hasSettings() {
        return this.get("settings") != null;
    }

    public boolean isWhitelisted() {
        return this.getBoolProperty("whitelisted");
    }

    public static class Builder {
        private final Iterable<RestApplicationUser> users;
        private RestTokenBucketSettings settings;
        private boolean whitelisted;

        public Builder(@Nonnull Iterable<ApplicationUser> users) {
            this.users = (Iterable)MoreStreams.streamIterable(Objects.requireNonNull(users, RestBulkUserRateLimitSettingsUpdateResponse.USERS)).map(user -> user instanceof RestApplicationUser ? (RestApplicationUser)user : new RestApplicationUser(user)).collect(MoreCollectors.toImmutableList());
        }

        public RestBulkUserRateLimitSettingsUpdateResponse build() {
            return new RestBulkUserRateLimitSettingsUpdateResponse(this);
        }

        public Builder whitelisted() {
            this.whitelisted = true;
            return this;
        }

        public Builder withSettings(RestTokenBucketSettings settings) {
            this.settings = settings;
            return this;
        }

        public Builder withSettings(TokenBucketSettings settings) {
            this.settings = RestTokenBucketSettings.valueOf(settings);
            return this;
        }
    }
}

