/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull.automerge;

import com.atlassian.bitbucket.pull.automerge.AutoMergeRequest;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=AutoMergeRequest.class)
public class RestAutoMergeRequest
extends RestMapEntity {
    private static final String AUTO_SUBJECT = "autoSubject";
    private static final String CREATED_DATE = "createdDate";
    private static final String FROM_HASH = "fromHash";
    private static final String MESSAGE = "message";
    private static final String STRATEGY_ID = "strategyId";
    private static final String TO_REF_ID = "toRefId";

    public RestAutoMergeRequest(@Nonnull AutoMergeRequest autoMergeRequest) {
        Objects.requireNonNull(autoMergeRequest, "autoMergeRequest");
        this.put(AUTO_SUBJECT, autoMergeRequest.isAutoSubject());
        this.put(CREATED_DATE, autoMergeRequest.getCreatedDate());
        this.put(FROM_HASH, autoMergeRequest.getFromHash());
        this.putIfNotNull(MESSAGE, autoMergeRequest.getMessage());
        this.putIfNotNull(STRATEGY_ID, autoMergeRequest.getStrategyId());
        this.put(TO_REF_ID, autoMergeRequest.getToRefId());
    }

    @Schema(example="true")
    public boolean getAutoSubject() {
        return this.getBoolProperty(AUTO_SUBJECT);
    }

    @Schema(example="13590759200")
    @Nonnull
    public long getCreatedDate() {
        return this.getLongProperty(CREATED_DATE);
    }

    @Schema(example="babecafebabecafebabecafebabecafebabecafe")
    @Nonnull
    public String getFromHash() {
        return this.getStringProperty(FROM_HASH);
    }

    @Schema(example="(Optional) A descriptive message for the merge commit")
    @Nullable
    public String getMessage() {
        return this.getStringProperty(MESSAGE);
    }

    @Schema(example="(Optional) squash")
    @Nullable
    public String getStrategyId() {
        return this.getStringProperty(STRATEGY_ID);
    }

    @Schema(example="refs/heads/feature-ABC-123")
    @Nonnull
    public String getToRefId() {
        return this.getStringProperty(TO_REF_ID);
    }
}

