/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.pull;

import com.atlassian.bitbucket.dmz.rest.v2.pull.RestPullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.commit.RestCommit;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonSerialize
@JsonSurrogate(value=PullRequestMergeActivity.class)
public class RestPullRequestMergeActivity
extends RestPullRequestActivity {
    private static final String AUTO_MERGE = "autoMerge";
    private static final String COMMIT = "commit";

    public RestPullRequestMergeActivity(PullRequestMergeActivity activity) {
        this(activity.getId(), activity.getCreatedDate(), new RestApplicationUser(activity.getUser()), activity.getAction(), RestPullRequestMergeActivity.applyOrNull(activity.getCommit(), RestCommit::new), activity.isAutoMerge());
    }

    private RestPullRequestMergeActivity(long id, Date createdDate, RestApplicationUser user, PullRequestAction action, RestCommit commit, boolean autoMerge) {
        super(id, createdDate, user, action);
        this.putIfNotNull(COMMIT, commit);
        this.put(AUTO_MERGE, autoMerge);
    }

    public RestCommit getCommit() {
        return (RestCommit)this.get(COMMIT);
    }

    public boolean isAutoMerge() {
        return this.getBoolProperty(AUTO_MERGE);
    }

    private static <F, T> T applyOrNull(@Nullable F from, @Nonnull Function<F, T> function) {
        if (from == null) {
            return null;
        }
        return Objects.requireNonNull(function, "function").apply(from);
    }
}

