/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.build;

import com.atlassian.bitbucket.build.status.TestResults;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import javax.annotation.Nullable;

@JsonSerialize
public class RestTestResults
extends RestMapEntity {
    private static final String FAILED = "failed";
    private static final String SKIPPED = "skipped";
    private static final String SUCCESSFUL = "successful";

    public RestTestResults() {
    }

    public RestTestResults(TestResults testResults) {
        if (testResults == null) {
            return;
        }
        testResults.getFailed().ifPresent(failed -> this.put(FAILED, failed));
        testResults.getSkipped().ifPresent(skipped -> this.put(SKIPPED, skipped));
        testResults.getSuccessful().ifPresent(successful -> this.put(SUCCESSFUL, successful));
    }

    public RestTestResults(Map<String, Object> value) {
        super(value);
    }

    public RestTestResults(Integer failed, Integer skipped, Integer successful) {
        this.putIfNotNull(FAILED, failed);
        this.putIfNotNull(SKIPPED, skipped);
        this.putIfNotNull(SUCCESSFUL, successful);
    }

    @Nullable
    public static RestTestResults valueOf(@Nullable Object testResults) {
        if (testResults instanceof RestTestResults) {
            return (RestTestResults)((Object)testResults);
        }
        if (testResults instanceof Map) {
            return new RestTestResults((Map)testResults);
        }
        return null;
    }

    @Schema(example="1")
    public Integer getFailed() {
        return this.getInteger(FAILED);
    }

    @Schema(example="5")
    public Integer getSkipped() {
        return this.getInteger(SKIPPED);
    }

    @Schema(example="134")
    public Integer getSuccessful() {
        return this.getInteger(SUCCESSFUL);
    }

    private Integer getInteger(String failed2) {
        int failed = this.getIntProperty(failed2);
        if (failed < 0) {
            return null;
        }
        return failed;
    }
}

